/*
 * Decompiled with CFR 0.152.
 */
package adams.data.instance;

import adams.core.Utils;
import adams.data.container.AbstractDataPoint;
import adams.data.container.DataPoint;
import adams.data.instance.Instance;
import weka.core.Attribute;

public class InstancePoint
extends AbstractDataPoint {
    private static final long serialVersionUID = -8737532674253304044L;
    protected Integer m_X;
    protected Double m_Y;

    public InstancePoint() {
        this(null, null);
    }

    public InstancePoint(Integer x, Double y) {
        this.setX(x);
        this.setY(y);
    }

    public void setX(Integer value) {
        this.m_X = value;
    }

    public Integer getX() {
        return this.m_X;
    }

    public void setY(Double value) {
        this.m_Y = value;
    }

    public Double getY() {
        return this.m_Y;
    }

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        int result = 0;
        InstancePoint other = (InstancePoint)((Object)o);
        if (result == 0) {
            result = this.getX().compareTo(other.getX());
        }
        if (result == 0) {
            result = this.getY().compareTo(other.getY());
        }
        return result;
    }

    public void assign(DataPoint other) {
        super.assign(other);
        InstancePoint point = (InstancePoint)other;
        this.setX(point.getX());
        this.setY(point.getY());
    }

    public InstancePoint parse(String s) {
        InstancePoint result = null;
        String[] parts = s.split(",");
        if (parts.length == 3) {
            result = new InstancePoint(Integer.parseInt(parts[1]), Utils.toDouble((String)parts[2]));
        }
        return result;
    }

    public String toString() {
        Object result;
        if (this.getParent() != null) {
            Attribute att = ((Instance)this.getParent()).getDatasetHeader().attribute(this.getX().intValue());
            result = att.name();
            result = (String)result + "=";
            result = att.isNominal() ? (String)result + att.value(this.getY().intValue()) : (String)result + this.getY();
        } else {
            result = this.getX() + "," + this.getY();
        }
        return result;
    }
}

