/*
 * Decompiled with CFR 0.152.
 */
package adams.data.instancesanalysis;

import adams.data.instancesanalysis.AbstractInstancesAnalysis;
import adams.data.instancesanalysis.pls.MatrixHelper;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.weka.WekaAttributeRange;
import com.github.waikatodatamining.matrix.core.Matrix;
import weka.core.Instances;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Remove;

public class FastICA
extends AbstractInstancesAnalysis {
    private static final long serialVersionUID = 7150143741822676345L;
    protected WekaAttributeRange m_AttributeRange;
    protected com.github.waikatodatamining.matrix.algorithm.ica.FastICA m_ICA;
    protected SpreadSheet m_Components;
    protected SpreadSheet m_Sources;

    public String globalInfo() {
        return "Performs independent components analysis (Fast ICA) and allows access to components and sources.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("attribute-range", "attributeRange", (Object)new WekaAttributeRange("first-last"));
        this.m_OptionManager.add("ica", "ICA", (Object)new com.github.waikatodatamining.matrix.algorithm.ica.FastICA());
    }

    protected void reset() {
        super.reset();
        this.m_Components = null;
        this.m_Sources = null;
    }

    public void setAttributeRange(WekaAttributeRange value) {
        this.m_AttributeRange = value;
        this.reset();
    }

    public WekaAttributeRange getAttributeRange() {
        return this.m_AttributeRange;
    }

    public String attributeRangeTipText() {
        return "The range of attributes to process.";
    }

    public void setICA(com.github.waikatodatamining.matrix.algorithm.ica.FastICA value) {
        this.m_ICA = value;
        this.reset();
    }

    public com.github.waikatodatamining.matrix.algorithm.ica.FastICA getICA() {
        return this.m_ICA;
    }

    public String ICATipText() {
        return "The ICA analysis setup to use.";
    }

    protected void check(Instances data) {
        super.check((Object)data);
        this.m_AttributeRange.setData(data);
        if (this.m_AttributeRange.getIntIndices().length == 0) {
            throw new IllegalStateException("No attributes selected with range: " + this.m_AttributeRange.getRange());
        }
    }

    protected String doAnalyze(Instances data) throws Exception {
        Matrix matrix;
        String result = null;
        this.m_Components = null;
        this.m_Sources = null;
        if (!this.m_AttributeRange.isAllRange()) {
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Filtering attribute range: " + this.m_AttributeRange.getRange());
            }
            Remove remove = new Remove();
            remove.setAttributeIndicesArray(this.m_AttributeRange.getIntIndices());
            remove.setInvertSelection(true);
            remove.setInputFormat(data);
            data = Filter.useFilter((Instances)data, (Filter)remove);
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Performing ICA...");
        }
        if ((matrix = this.m_ICA.transform(MatrixHelper.wekaToMatrixAlgo(MatrixHelper.getAll(data)))) != null) {
            this.m_Components = MatrixHelper.matrixToSpreadSheet(MatrixHelper.matrixAlgoToWeka(this.m_ICA.getComponents()), "Component-");
            this.m_Sources = MatrixHelper.matrixToSpreadSheet(MatrixHelper.matrixAlgoToWeka(this.m_ICA.getSources()), "Source-");
        } else {
            result = "Failed to transform data!";
        }
        return result;
    }

    public SpreadSheet getComponents() {
        return this.m_Components;
    }

    public SpreadSheet getSources() {
        return this.m_Sources;
    }
}

