/*
 * Decompiled with CFR 0.152.
 */
package adams.data.instancesanalysis.pls;

import adams.data.instancesanalysis.pls.AbstractPLS;
import java.util.ArrayList;
import java.util.Map;
import weka.core.Attribute;
import weka.core.Instances;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Center;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;
import weka.filters.unsupervised.attribute.Standardize;

public abstract class AbstractSingleClassPLS
extends AbstractPLS {
    private static final long serialVersionUID = 5649007256147616278L;
    public static final String PARAM_CLASSVALUES = "classValues";
    protected Filter m_Missing;
    protected Filter m_Filter;
    protected double m_ClassMean;
    protected double m_ClassStdDev;

    @Override
    public void reset() {
        super.reset();
        this.m_Missing = null;
        this.m_Filter = null;
    }

    @Override
    public Instances determineOutputFormat(Instances input) throws Exception {
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        String prefix = this.getClass().getSimpleName();
        for (int i = 0; i < this.getNumComponents(); ++i) {
            atts.add(new Attribute(prefix + "_" + (i + 1)));
        }
        atts.add(new Attribute(input.classAttribute().name()));
        Instances result = new Instances(prefix, atts, 0);
        result.setClassIndex(result.numAttributes() - 1);
        this.m_OutputFormat = result;
        return result;
    }

    @Override
    protected Instances preTransform(Instances instances, Map<String, Object> params) throws Exception {
        double[] classValues;
        switch (this.m_PredictionType) {
            case ALL: {
                classValues = null;
                break;
            }
            default: {
                classValues = instances.attributeToDoubleArray(instances.classIndex());
            }
        }
        if (classValues != null) {
            params.put(PARAM_CLASSVALUES, classValues);
        }
        if (!this.isInitialized()) {
            if (this.m_ReplaceMissing) {
                this.m_Missing = new ReplaceMissingValues();
                this.m_Missing.setInputFormat(instances);
            } else {
                this.m_Missing = null;
            }
            switch (this.m_PreprocessingType) {
                case CENTER: {
                    this.m_ClassMean = instances.meanOrMode(instances.classIndex());
                    this.m_ClassStdDev = 1.0;
                    this.m_Filter = new Center();
                    ((Center)this.m_Filter).setIgnoreClass(true);
                    break;
                }
                case STANDARDIZE: {
                    this.m_ClassMean = instances.meanOrMode(instances.classIndex());
                    this.m_ClassStdDev = StrictMath.sqrt(instances.variance(instances.classIndex()));
                    this.m_Filter = new Standardize();
                    ((Standardize)this.m_Filter).setIgnoreClass(true);
                    break;
                }
                case NONE: {
                    this.m_ClassMean = 0.0;
                    this.m_ClassStdDev = 1.0;
                    this.m_Filter = null;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled preprocessing type; " + this.m_PreprocessingType);
                }
            }
            if (this.m_Filter != null) {
                this.m_Filter.setInputFormat(instances);
            }
        }
        if (this.m_Missing != null) {
            instances = Filter.useFilter((Instances)instances, (Filter)this.m_Missing);
        }
        if (this.m_Filter != null) {
            instances = Filter.useFilter((Instances)instances, (Filter)this.m_Filter);
        }
        return instances;
    }

    @Override
    protected Instances postTransform(Instances instances, Map<String, Object> params) throws Exception {
        double[] classValues = (double[])params.get(PARAM_CLASSVALUES);
        for (int i = 0; i < instances.numInstances(); ++i) {
            if (classValues != null) {
                instances.instance(i).setClassValue(classValues[i]);
                continue;
            }
            double classValue = instances.instance(i).classValue();
            instances.instance(i).setClassValue(classValue * this.m_ClassStdDev + this.m_ClassMean);
        }
        return instances;
    }
}

