/*
 * Decompiled with CFR 0.152.
 */
package adams.data.instancesanalysis.pls;

import adams.core.TechnicalInformation;
import adams.data.instancesanalysis.pls.AbstractSingleClassPLS;
import adams.data.instancesanalysis.pls.MatrixHelper;
import com.github.waikatodatamining.matrix.core.Matrix;
import com.github.waikatodatamining.matrix.core.PreprocessingType;
import java.util.Map;
import weka.core.Instances;

public class DIPLS
extends AbstractSingleClassPLS {
    private static final long serialVersionUID = -1605633160253194760L;
    protected com.github.waikatodatamining.matrix.algorithm.pls.DIPLS m_DIPLS;
    protected double m_Lambda;

    public String globalInfo() {
        return "Domain Invariant Partial Least Squares (DIPLS).\n\nFor more information see:\n" + this.getTechnicalInformation();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Ramin Nikzad-Langerodi, Werner Zellinger, Edwin Lughofer, and Susanne Saminger-Platz");
        result.setValue(TechnicalInformation.Field.TITLE, "Domain-Invariant Partial-Least-Squares Regression");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Analytical Chemistry");
        result.setValue(TechnicalInformation.Field.VOLUME, "90");
        result.setValue(TechnicalInformation.Field.NUMBER, "11");
        result.setValue(TechnicalInformation.Field.PAGES, "6693-6701");
        result.setValue(TechnicalInformation.Field.URL, "https://pubs.acs.org/doi/10.1021/acs.analchem.8b00498");
        return result;
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("lambda", "lambda", (Object)1.0, (Number)1.0E-8, null);
    }

    public void setLambda(double value) {
        if (this.getOptionManager().isValid("lambda", (Number)value)) {
            this.m_Lambda = value;
            this.reset();
        }
    }

    public double getLambda() {
        return this.m_Lambda;
    }

    public String lambdaTipText() {
        return "The lambda (> 0).";
    }

    @Override
    public String[] getMatrixNames() {
        return this.m_DIPLS.getMatrixNames();
    }

    @Override
    public weka.core.matrix.Matrix getMatrix(String name) {
        return MatrixHelper.matrixAlgoToWeka(this.m_DIPLS.getMatrix(name));
    }

    @Override
    public boolean hasLoadings() {
        return this.m_DIPLS.hasLoadings();
    }

    @Override
    public weka.core.matrix.Matrix getLoadings() {
        return MatrixHelper.matrixAlgoToWeka(this.m_DIPLS.getLoadings());
    }

    @Override
    protected Instances doTransform(Instances data, Map<String, Object> params) throws Exception {
        Matrix X = MatrixHelper.wekaToMatrixAlgo(MatrixHelper.getX(data));
        Matrix y = MatrixHelper.wekaToMatrixAlgo(MatrixHelper.getY(data));
        if (!this.isInitialized()) {
            this.m_DIPLS = new com.github.waikatodatamining.matrix.algorithm.pls.DIPLS();
            this.m_DIPLS.setNumComponents(this.m_NumComponents);
            this.m_DIPLS.setPreprocessingType(PreprocessingType.NONE);
            this.m_DIPLS.setLambda(this.m_Lambda);
            String error = this.m_DIPLS.initialize(X, y);
            if (error != null) {
                throw new Exception(error);
            }
        }
        Matrix X_new = this.m_DIPLS.transform(X);
        return MatrixHelper.toInstances(this.getOutputFormat(), MatrixHelper.matrixAlgoToWeka(X_new), MatrixHelper.matrixAlgoToWeka(y));
    }
}

