/*
 * Decompiled with CFR 0.152.
 */
package adams.data.instancesanalysis.pls;

import adams.core.TechnicalInformation;
import adams.core.option.OptionUtils;
import adams.data.instancesanalysis.pls.AbstractMultiClassPLS;
import adams.data.instancesanalysis.pls.MatrixHelper;
import com.github.waikatodatamining.matrix.core.Matrix;
import com.github.waikatodatamining.matrix.core.PreprocessingType;
import com.github.waikatodatamining.matrix.transformation.kernel.AbstractKernel;
import com.github.waikatodatamining.matrix.transformation.kernel.RBFKernel;
import java.util.Map;
import weka.core.Instances;

public class KernelPLS
extends AbstractMultiClassPLS {
    private static final long serialVersionUID = 3943381091993382352L;
    protected AbstractKernel m_Kernel;
    protected double m_Tol;
    protected int m_MaxIter;
    protected com.github.waikatodatamining.matrix.algorithm.pls.KernelPLS m_KernelPLS;

    public String globalInfo() {
        return "Kernel Partial Least Squares Regression in Reproducing Kernel Hilbert Space\n\nFor more information see:\n" + this.getTechnicalInformation();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Roman Rosipal and Leonard J. Trejo");
        result.setValue(TechnicalInformation.Field.YEAR, "2001");
        result.setValue(TechnicalInformation.Field.TITLE, "Kernel Partial Least Squares Regression in Reproducing Kernel Hilbert Space");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Journal of Machine Learning Research");
        result.setValue(TechnicalInformation.Field.VOLUME, "2");
        result.setValue(TechnicalInformation.Field.PAGES, "97-123");
        result.setValue(TechnicalInformation.Field.URL, "http://www.jmlr.org/papers/volume2/rosipal01a/rosipal01a.pdf");
        return result;
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("kernel", "kernel", (Object)new RBFKernel());
        this.m_OptionManager.add("tol", "tol", (Object)1.0E-6, (Number)0.0, null);
        this.m_OptionManager.add("max-iter", "maxIter", (Object)500, (Number)1, null);
    }

    public void setKernel(AbstractKernel value) {
        this.m_Kernel = value;
        this.reset();
    }

    public AbstractKernel getKernel() {
        return this.m_Kernel;
    }

    public String kernelipText() {
        return "The kernel to use";
    }

    public void setTol(double value) {
        this.m_Tol = value;
        this.reset();
    }

    public double getTol() {
        return this.m_Tol;
    }

    public String tolipText() {
        return "The inner NIPALS loop maximum number of iterations.";
    }

    public void setMaxIter(int value) {
        this.m_MaxIter = value;
        this.reset();
    }

    public int getMaxIter() {
        return this.m_MaxIter;
    }

    public String maxIteripText() {
        return "The inner NIPALS loop improvement tolerance.";
    }

    @Override
    public String[] getMatrixNames() {
        return this.m_KernelPLS.getMatrixNames();
    }

    @Override
    public weka.core.matrix.Matrix getMatrix(String name) {
        return MatrixHelper.matrixAlgoToWeka(this.m_KernelPLS.getMatrix(name));
    }

    @Override
    public boolean hasLoadings() {
        return this.m_KernelPLS.hasLoadings();
    }

    @Override
    public weka.core.matrix.Matrix getLoadings() {
        return MatrixHelper.matrixAlgoToWeka(this.m_KernelPLS.getLoadings());
    }

    @Override
    protected Instances doTransform(Instances data, Map<String, Object> params) throws Exception {
        int[] cols = this.m_ClassAttributeIndices.toArray();
        Matrix X = MatrixHelper.wekaToMatrixAlgo(MatrixHelper.getX(data));
        Matrix Y = MatrixHelper.wekaToMatrixAlgo(MatrixHelper.getY(data, cols));
        if (!this.isInitialized()) {
            this.m_KernelPLS = new com.github.waikatodatamining.matrix.algorithm.pls.KernelPLS();
            this.m_KernelPLS.setKernel((AbstractKernel)OptionUtils.shallowCopy((Object)this.m_Kernel));
            this.m_KernelPLS.setNumComponents(this.m_NumComponents);
            this.m_KernelPLS.setPreprocessingType(PreprocessingType.NONE);
            this.m_KernelPLS.setTol(this.m_Tol);
            this.m_KernelPLS.setMaxIter(this.m_MaxIter);
            String error = this.m_KernelPLS.initialize(X, Y);
            if (error != null) {
                throw new Exception(error);
            }
        }
        Matrix X_new = this.m_KernelPLS.transform(X);
        return MatrixHelper.toInstances(this.getOutputFormat(), MatrixHelper.matrixAlgoToWeka(X_new), MatrixHelper.matrixAlgoToWeka(Y));
    }
}

