/*
 * Decompiled with CFR 0.152.
 */
package adams.data.instancesanalysis.pls;

import adams.core.TechnicalInformation;
import adams.core.Utils;
import adams.data.instancesanalysis.pls.AbstractSingleClassPLS;
import java.util.Map;
import weka.core.Instances;
import weka.core.matrix.Matrix;
import weka.core.matrix.MatrixHelper;

public class SIMPLS
extends AbstractSingleClassPLS {
    private static final long serialVersionUID = -2148100447010845646L;
    protected int m_NumCoefficients;
    protected Matrix m_W;
    protected Matrix m_B;

    public String globalInfo() {
        return "Implementation of SIMPLS algorithm.\n\nAvailable matrices: " + Utils.flatten((Object[])this.getMatrixNames(), (String)", ") + "\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.BOOK);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Tormod Naes and Tomas Isaksson and Tom Fearn and Tony Davies");
        result.setValue(TechnicalInformation.Field.YEAR, "2002");
        result.setValue(TechnicalInformation.Field.TITLE, "A User Friendly Guide to Multivariate Calibration and Classification");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "NIR Publications");
        result.setValue(TechnicalInformation.Field.ISBN, "0-9528666-2-5");
        TechnicalInformation additional = result.add(TechnicalInformation.Type.ARTICLE);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "S. de Jong");
        additional.setValue(TechnicalInformation.Field.YEAR, "1993");
        additional.setValue(TechnicalInformation.Field.TITLE, "SIMPLS: an alternative approach to partial least squares regression");
        additional.setValue(TechnicalInformation.Field.JOURNAL, "Chemometrics and Intelligent Laboratory Systems");
        additional.setValue(TechnicalInformation.Field.VOLUME, "18");
        additional.setValue(TechnicalInformation.Field.PAGES, "251-263");
        return result;
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("num-coefficients", "numCoefficients", (Object)0, (Number)0, null);
    }

    @Override
    public void reset() {
        super.reset();
        this.m_B = null;
        this.m_W = null;
    }

    public void setNumCoefficients(int value) {
        this.m_NumCoefficients = value;
        this.reset();
    }

    public int getNumCoefficients() {
        return this.m_NumCoefficients;
    }

    public String numCoefficientsTipText() {
        return "The number of coefficients of W matrix to keep (rest gets zeroed); use 0 to keep all.";
    }

    @Override
    public String[] getMatrixNames() {
        return new String[]{"W", "B"};
    }

    @Override
    public Matrix getMatrix(String name) {
        switch (name) {
            case "W": {
                return this.m_W;
            }
            case "B": {
                return this.m_B;
            }
        }
        return null;
    }

    @Override
    public boolean hasLoadings() {
        return true;
    }

    @Override
    public Matrix getLoadings() {
        return this.getMatrix("W");
    }

    protected void slim(Matrix in) {
        double[][] B = in.getArray();
        for (int i = 0; i < in.getColumnDimension(); ++i) {
            Matrix l = in.getMatrix(0, in.getRowDimension() - 1, i, i);
            double[] ld = l.getRowPackedCopy();
            for (int t = 0; t < ld.length; ++t) {
                ld[t] = Math.abs(ld[t]);
            }
            int[] srt = weka.core.Utils.sort((double[])ld);
            int index = srt[Math.max(srt.length - 1 - this.getNumCoefficients(), 0)];
            double val = ld[index];
            for (int c = 0; c < in.getRowDimension(); ++c) {
                if (!(Math.abs(B[c][i]) < val)) continue;
                B[c][i] = 0.0;
            }
        }
    }

    @Override
    protected Instances doTransform(Instances data, Map<String, Object> params) throws Exception {
        Instances result;
        if (!this.isInitialized()) {
            Matrix y;
            Matrix T;
            Matrix X = MatrixHelper.getX(data);
            Matrix X_trans = X.transpose();
            Matrix Y = MatrixHelper.getY(data);
            Matrix A = X_trans.times(Y);
            Matrix M = X_trans.times(X);
            Matrix C = Matrix.identity((int)(data.numAttributes() - 1), (int)(data.numAttributes() - 1));
            Matrix W = new Matrix(data.numAttributes() - 1, this.getNumComponents());
            Matrix P = new Matrix(data.numAttributes() - 1, this.getNumComponents());
            Matrix Q = new Matrix(1, this.getNumComponents());
            for (int h = 0; h < this.getNumComponents(); ++h) {
                Matrix A_trans = A.transpose();
                Matrix q = MatrixHelper.getDominantEigenVector(A_trans.times(A));
                Matrix w = A.times(q);
                Matrix c = w.transpose().times(M).times(w);
                w = w.times(1.0 / StrictMath.sqrt(c.get(0, 0)));
                MatrixHelper.setVector(w, W, h);
                Matrix p = M.times(w);
                Matrix p_trans = p.transpose();
                MatrixHelper.setVector(p, P, h);
                q = A_trans.times(w);
                MatrixHelper.setVector(q, Q, h);
                Matrix v = C.times(p);
                MatrixHelper.normalizeVector(v);
                Matrix v_trans = v.transpose();
                C = C.minus(v.times(v_trans));
                M = M.minus(p.times(p_trans));
                A = C.times(A);
            }
            if (this.getNumCoefficients() > 0) {
                this.slim(W);
            }
            this.m_W = W;
            Matrix X_new = T = X.times(this.m_W);
            this.m_B = W.times(Q.transpose());
            switch (this.m_PredictionType) {
                case ALL: {
                    y = T.times(P.transpose()).times(this.m_B);
                    break;
                }
                case NONE: 
                case EXCEPT_CLASS: {
                    y = MatrixHelper.getY(data);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled prediction type: " + this.m_PredictionType);
                }
            }
            result = MatrixHelper.toInstances(this.getOutputFormat(), X_new, y);
        } else {
            Matrix y;
            Matrix X = MatrixHelper.getX(data);
            Matrix X_new = X.times(this.m_W);
            switch (this.m_PredictionType) {
                case ALL: {
                    y = X.times(this.m_B);
                    break;
                }
                case NONE: 
                case EXCEPT_CLASS: {
                    y = MatrixHelper.getY(data);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled prediction type: " + this.m_PredictionType);
                }
            }
            result = MatrixHelper.toInstances(this.getOutputFormat(), X_new, y);
        }
        return result;
    }
}

