/*
 * Decompiled with CFR 0.152.
 */
package adams.data.instancesanalysis.pls;

import adams.core.TechnicalInformation;
import adams.data.instancesanalysis.pls.AbstractSingleClassPLS;
import adams.data.instancesanalysis.pls.MatrixHelper;
import com.github.waikatodatamining.matrix.core.Matrix;
import com.github.waikatodatamining.matrix.core.PreprocessingType;
import java.util.Map;
import weka.core.Instances;

public class VCPLS
extends AbstractSingleClassPLS {
    private static final long serialVersionUID = -1605633160253194760L;
    protected com.github.waikatodatamining.matrix.algorithm.pls.VCPLS m_VCPLS;
    protected double m_Lambda;

    public String globalInfo() {
        return "Variance constrained partial least squares.\n\nFor more information see:\n" + this.getTechnicalInformation();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Xiubao Jiang, Xinge You, Shujian Yu, Dacheng Tao, C.L. Philip Chen, Yiu-ming Cheung");
        result.setValue(TechnicalInformation.Field.YEAR, "2015");
        result.setValue(TechnicalInformation.Field.TITLE, "Variance constrained partial least squares");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Chemometrics and Intelligent Laboratory Systems");
        result.setValue(TechnicalInformation.Field.VOLUME, "145");
        result.setValue(TechnicalInformation.Field.PAGES, "60-71");
        result.setValue(TechnicalInformation.Field.URL, "http://dx.doi.org/10.1016/j.chemolab.2015.04.014");
        result.setValue(TechnicalInformation.Field.HTTP, "http://or.nsfc.gov.cn/bitstream/00001903-5/485833/1/1000013952154.pdf");
        return result;
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("lambda", "lambda", (Object)1.0);
    }

    public void setLambda(double value) {
        this.m_Lambda = value;
        this.reset();
    }

    public double getLambda() {
        return this.m_Lambda;
    }

    public String lambdaTipText() {
        return "The lambda parameter.";
    }

    @Override
    public String[] getMatrixNames() {
        return this.m_VCPLS.getMatrixNames();
    }

    @Override
    public weka.core.matrix.Matrix getMatrix(String name) {
        return MatrixHelper.matrixAlgoToWeka(this.m_VCPLS.getMatrix(name));
    }

    @Override
    public boolean hasLoadings() {
        return this.m_VCPLS.hasLoadings();
    }

    @Override
    public weka.core.matrix.Matrix getLoadings() {
        return MatrixHelper.matrixAlgoToWeka(this.m_VCPLS.getLoadings());
    }

    @Override
    protected Instances doTransform(Instances data, Map<String, Object> params) throws Exception {
        Matrix X = MatrixHelper.wekaToMatrixAlgo(MatrixHelper.getX(data));
        Matrix y = MatrixHelper.wekaToMatrixAlgo(MatrixHelper.getY(data));
        if (!this.isInitialized()) {
            this.m_VCPLS = new com.github.waikatodatamining.matrix.algorithm.pls.VCPLS();
            this.m_VCPLS.setNumComponents(this.m_NumComponents);
            this.m_VCPLS.setPreprocessingType(PreprocessingType.NONE);
            this.m_VCPLS.setLambda(this.m_Lambda);
            String error = this.m_VCPLS.initialize(X, y);
            if (error != null) {
                throw new Exception(error);
            }
        }
        Matrix X_new = this.m_VCPLS.transform(X);
        return MatrixHelper.toInstances(this.getOutputFormat(), MatrixHelper.matrixAlgoToWeka(X_new), MatrixHelper.matrixAlgoToWeka(y));
    }
}

