/*
 * Decompiled with CFR 0.152.
 */
package adams.data.weka.datasetsplitter;

import adams.data.weka.columnfinder.ColumnFinder;
import adams.data.weka.columnfinder.NullFinder;
import adams.data.weka.datasetsplitter.AbstractSplitter;
import java.util.ArrayList;
import java.util.Arrays;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;

public class ColumnSplitter
extends AbstractSplitter {
    private static final long serialVersionUID = 5451391004405077402L;
    protected ColumnFinder m_ColumnFinder;
    protected int[][] m_SourceLookup;

    public String globalInfo() {
        return "Splits a dataset in two based on the columns selected by a column-finder. Selected columns go in the first dataset, and the rest go in the second.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("column-finder", "columnFinder", (Object)new NullFinder());
    }

    public ColumnFinder getColumnFinder() {
        return this.m_ColumnFinder;
    }

    public void setColumnFinder(ColumnFinder value) {
        this.m_ColumnFinder = value;
        this.reset();
    }

    public String columnFinderTipText() {
        return "Column-finder defining which attributes go into which dataset.";
    }

    public String check(Instances dataset) {
        if (dataset == null) {
            return "Dataset not supplied.";
        }
        return null;
    }

    protected int[] getUnselectedColumns(int[] selectedColumns, int numColumns) {
        int nextSelectedColumnIndex = 0;
        int nextSelectedColumn = this.getSelectedColumn(selectedColumns, nextSelectedColumnIndex);
        int nextUnselectedColumnIndex = 0;
        int[] unselectedColumns = new int[numColumns - selectedColumns.length];
        for (int i = 0; i < numColumns; ++i) {
            if (i == nextSelectedColumn) {
                nextSelectedColumn = this.getSelectedColumn(selectedColumns, ++nextSelectedColumnIndex);
                continue;
            }
            unselectedColumns[nextUnselectedColumnIndex] = i;
            ++nextUnselectedColumnIndex;
        }
        return unselectedColumns;
    }

    protected int getSelectedColumn(int[] selectedColumns, int index) {
        if (index < selectedColumns.length) {
            return selectedColumns[index];
        }
        return -1;
    }

    protected ArrayList<Attribute>[] splitAttributes(Instances dataset) {
        Attribute attribute;
        int[] selectedColumns = this.m_ColumnFinder.findColumns(dataset);
        Arrays.sort(selectedColumns);
        int[] unselectedColumns = this.getUnselectedColumns(selectedColumns, dataset.numAttributes());
        this.m_SourceLookup = new int[][]{selectedColumns, unselectedColumns};
        ArrayList[] result = new ArrayList[]{new ArrayList(selectedColumns.length), new ArrayList(unselectedColumns.length)};
        for (int selectedColumn : selectedColumns) {
            attribute = (Attribute)dataset.attribute(selectedColumn).copy();
            result[0].add(attribute);
        }
        for (int unselectedColumn : unselectedColumns) {
            attribute = (Attribute)dataset.attribute(unselectedColumn).copy();
            result[1].add(attribute);
        }
        return result;
    }

    protected Instance newInstanceForDataset(Instances dataset) {
        DenseInstance result = new DenseInstance(dataset.numAttributes());
        result.setDataset(dataset);
        return result;
    }

    @Override
    public Instances[] split(Instances dataset) {
        String error = this.check(dataset);
        if (error != null) {
            throw new IllegalArgumentException(error);
        }
        ArrayList<Attribute>[] attributeSplit = this.splitAttributes(dataset);
        Instances[] result = new Instances[]{new Instances(dataset.relationName(), attributeSplit[0], dataset.numInstances()), new Instances(dataset.relationName(), attributeSplit[1], dataset.numInstances())};
        if (attributeSplit[0].size() == 0) {
            return new Instances[]{result[0], dataset};
        }
        if (attributeSplit[1].size() == 0) {
            return new Instances[]{dataset, result[1]};
        }
        for (int instanceIndex = 0; instanceIndex < dataset.numInstances(); ++instanceIndex) {
            Instance sourceInstance = dataset.instance(instanceIndex);
            for (int resultIndex = 0; resultIndex < 2; ++resultIndex) {
                Instances resultDataset = result[resultIndex];
                Instance resultInstance = this.newInstanceForDataset(resultDataset);
                for (int attributeIndex = 0; attributeIndex < resultDataset.numAttributes(); ++attributeIndex) {
                    Attribute attribute = resultInstance.attribute(attributeIndex);
                    double sourceValue = sourceInstance.value(this.m_SourceLookup[resultIndex][attributeIndex]);
                    resultInstance.setValue(attributeIndex, sourceValue);
                }
                resultInstance.setWeight(sourceInstance.weight());
                resultDataset.add(resultInstance);
            }
        }
        return result;
    }
}

