/*
 * Decompiled with CFR 0.152.
 */
package adams.data.weka.datasetsplitter;

import adams.data.weka.datasetsplitter.AbstractSplitter;
import adams.data.weka.rowfinder.NullFinder;
import adams.data.weka.rowfinder.RowFinder;
import java.util.Arrays;
import weka.core.Instance;
import weka.core.Instances;

public class RowSplitter
extends AbstractSplitter {
    private static final long serialVersionUID = 4638233201875563585L;
    public static final int NO_NEXT_SELECTED_INDEX = -1;
    protected RowFinder m_RowFinder;

    public String globalInfo() {
        return "Splits a dataset in two based on the rows selected by the row-finder. Instances found by the row-finder go in the first dataset, and the rest go in the second.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("row-finder", "rowFinder", (Object)new NullFinder());
    }

    public RowFinder getRowFinder() {
        return this.m_RowFinder;
    }

    public void setRowFinder(RowFinder value) {
        this.m_RowFinder = value;
        this.reset();
    }

    public String rowFinderTipText() {
        return "The row-finder to use to select rows for the first dataset.";
    }

    public String check(Instances dataset) {
        if (dataset == null) {
            return "Dataset not supplied.";
        }
        return null;
    }

    protected int getNextSelectedIndex(int[] selectedIndices, int index) {
        if (index >= selectedIndices.length) {
            return -1;
        }
        return selectedIndices[index];
    }

    @Override
    public Instances[] split(Instances dataset) {
        String error = this.check(dataset);
        if (error != null) {
            throw new IllegalArgumentException(error);
        }
        int[] selectedIndices = this.m_RowFinder.findRows(dataset);
        if (selectedIndices.length == 0) {
            return new Instances[]{new Instances(dataset, 0), dataset};
        }
        if (selectedIndices.length == dataset.numInstances()) {
            return new Instances[]{dataset, new Instances(dataset, 0)};
        }
        Arrays.sort(selectedIndices);
        int selectedIndicesIndex = 0;
        int nextSelectedIndex = this.getNextSelectedIndex(selectedIndices, selectedIndicesIndex);
        Instances[] result = new Instances[]{new Instances(dataset, 0), new Instances(dataset, 0)};
        for (int i = 0; i < dataset.numInstances(); ++i) {
            Instance copy = (Instance)dataset.instance(i).copy();
            if (i == nextSelectedIndex) {
                result[0].add(copy);
                nextSelectedIndex = this.getNextSelectedIndex(selectedIndices, ++selectedIndicesIndex);
                continue;
            }
            result[1].add(copy);
        }
        return result;
    }
}

