/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.condition.bool;

import adams.core.MessageCollection;
import adams.core.QuickInfoHelper;
import adams.core.SerializationHelper;
import adams.core.io.ModelFileHandler;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.condition.bool.AbstractBooleanCondition;
import adams.flow.condition.bool.IndexedBooleanCondition;
import adams.flow.container.WekaModelContainer;
import adams.flow.core.Actor;
import adams.flow.core.CallableActorHelper;
import adams.flow.core.CallableActorReference;
import adams.flow.core.Token;
import java.util.logging.Level;
import weka.classifiers.Classifier;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Utils;

public class WekaClassification
extends AbstractBooleanCondition
implements IndexedBooleanCondition,
ModelFileHandler {
    private static final long serialVersionUID = 3278345095591806425L;
    protected PlaceholderFile m_ModelFile;
    protected CallableActorReference m_ModelActor;
    protected Classifier m_Model;
    protected boolean m_OnTheFly;

    public String globalInfo() {
        return "Uses the index of the classification, i.e., the predicted label, as index of the switch";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("model", "modelFile", (Object)new PlaceholderFile("."));
        this.m_OptionManager.add("model-actor", "modelActor", (Object)new CallableActorReference());
        this.m_OptionManager.add("on-the-fly", "onTheFly", (Object)false);
    }

    public void setModelFile(PlaceholderFile value) {
        this.m_ModelFile = value;
        this.reset();
    }

    public PlaceholderFile getModelFile() {
        return this.m_ModelFile;
    }

    public String modelFileTipText() {
        return "The model file to load (when not pointing to a directory).";
    }

    public void setModelActor(CallableActorReference value) {
        this.m_ModelActor = value;
        this.reset();
    }

    public CallableActorReference getModelActor() {
        return this.m_ModelActor;
    }

    public String modelActorTipText() {
        return "The callable actor to use for obtaining the model in case serialized model file points to a directory; can be a " + WekaModelContainer.class.getName() + " as well.";
    }

    public void setOnTheFly(boolean value) {
        this.m_OnTheFly = value;
        this.reset();
    }

    public boolean getOnTheFly() {
        return this.m_OnTheFly;
    }

    public String onTheFlyTipText() {
        return "If set to true, the model file is not required to be present at set up time (eg if built on the fly), only at execution time.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"modelFile", (Object)(this.m_ModelFile.isDirectory() ? this.m_ModelActor.getValue() : this.m_ModelFile));
    }

    public Class[] accepts() {
        return new Class[]{Instance.class};
    }

    protected String setUpModel(Actor owner) {
        Capabilities caps;
        Object result;
        block10: {
            result = null;
            if (this.m_ModelFile.isDirectory()) {
                try {
                    MessageCollection errors = new MessageCollection();
                    Object obj = CallableActorHelper.getSetup(Classifier.class, (CallableActorReference)this.m_ModelActor, (Actor)owner, (MessageCollection)errors);
                    if (obj == null) {
                        if (!errors.isEmpty()) {
                            result = errors.toString();
                        }
                        break block10;
                    }
                    if (obj instanceof WekaModelContainer) {
                        this.m_Model = (Classifier)((WekaModelContainer)((Object)obj)).getValue("Model");
                        break block10;
                    }
                    this.m_Model = (Classifier)obj;
                }
                catch (Exception e) {
                    this.m_Model = null;
                    String msg = "Failed to obtain model from callable actor '" + this.m_ModelActor + "': ";
                    result = msg + e.toString();
                    this.getLogger().log(Level.SEVERE, msg, (Throwable)e);
                }
            } else {
                try {
                    this.m_Model = (Classifier)SerializationHelper.read((String)this.m_ModelFile.getAbsolutePath());
                }
                catch (Exception e) {
                    this.m_Model = null;
                    String msg = "Failed to load model from '" + this.m_ModelFile + "': ";
                    result = msg + e.toString();
                    this.getLogger().log(Level.SEVERE, msg, (Throwable)e);
                }
            }
        }
        if (!(this.m_Model == null || (caps = this.m_Model.getCapabilities()).handles(Capabilities.Capability.UNARY_CLASS) || caps.handles(Capabilities.Capability.BINARY_CLASS) || caps.handles(Capabilities.Capability.NOMINAL_CLASS))) {
            result = "Model can neither handle unary, binary nor nominal class attribute!";
        }
        return result;
    }

    public String setUp(Actor owner) {
        String result = super.setUp(owner);
        if (result == null && !this.m_OnTheFly) {
            result = this.setUpModel(owner);
        }
        return result;
    }

    protected boolean doEvaluate(Actor owner, Token token) {
        return this.getCaseIndex(owner, token) != -1;
    }

    public int getCaseIndex(Actor owner, Token token) {
        String msg;
        int result = -1;
        if (this.m_OnTheFly && this.m_Model == null && (msg = this.setUpModel(owner)) != null) {
            this.getLogger().severe(msg);
            return result;
        }
        if (token != null && token.getPayload() != null) {
            Instance inst = (Instance)token.getPayload();
            if (inst.classIndex() == -1) {
                this.getLogger().severe("No class set!");
                return result;
            }
            if (!inst.classAttribute().isNominal()) {
                this.getLogger().severe("Class attribute is not nominal!");
                return result;
            }
            try {
                double classification = this.m_Model.classifyInstance(inst);
                result = Utils.isMissingValue((double)classification) ? -1 : (int)classification;
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Failed to obtain classification: ", (Throwable)e);
            }
        }
        return result;
    }

    public int getDefaultCaseIndex(Actor owner, Token token) {
        Instance inst = (Instance)token.getPayload();
        return inst.classAttribute().numValues();
    }
}

