/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.container;

import adams.flow.container.AbstractContainer;
import java.util.ArrayList;
import java.util.Iterator;
import weka.core.Instances;

public class WekaModelContainer
extends AbstractContainer {
    private static final long serialVersionUID = 5581530171877321061L;
    public static final String VALUE_MODEL = "Model";
    public static final String VALUE_HEADER = "Header";
    public static final String VALUE_DATASET = "Dataset";

    public WekaModelContainer() {
        this(null);
    }

    public WekaModelContainer(Object model) {
        this(model, null);
    }

    public WekaModelContainer(Object model, Instances header) {
        this(model, header, null);
    }

    public WekaModelContainer(Object model, Instances header, Instances data) {
        this.store(VALUE_MODEL, model);
        this.store(VALUE_HEADER, header);
        this.store(VALUE_DATASET, data);
    }

    protected void initHelp() {
        super.initHelp();
        this.addHelp(VALUE_MODEL, "model object", Object.class);
        this.addHelp(VALUE_HEADER, "dataset header", Instances.class);
        this.addHelp(VALUE_DATASET, "full dataset", Instances.class);
    }

    public Iterator<String> names() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(VALUE_MODEL);
        result.add(VALUE_HEADER);
        result.add(VALUE_DATASET);
        return result.iterator();
    }

    public boolean isValid() {
        return (this.hasValue(VALUE_MODEL) && !this.hasValue(VALUE_HEADER)) | (this.hasValue(VALUE_MODEL) && this.hasValue(VALUE_HEADER));
    }
}

