/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.core;

import adams.core.EnumWithCustomDisplay;
import adams.core.option.AbstractOption;

public enum EvaluationStatistic implements EnumWithCustomDisplay<EvaluationStatistic>
{
    NUMBER_CORRECT("Number correct", true),
    NUMBER_INCORRECT("Number incorrect", true),
    NUMBER_UNCLASSIFIED("Number unclassified", true),
    PERCENT_CORRECT("Percent correct", true),
    PERCENT_INCORRECT("Percent incorrect", true),
    PERCENT_UNCLASSIFIED("Percent unclassified", true),
    KAPPA_STATISTIC("Kappa statistic", true),
    MEAN_ABSOLUTE_ERROR("Mean absolute error", null),
    ROOT_MEAN_SQUARED_ERROR("Root mean squared error", null),
    RELATIVE_ABSOLUTE_ERROR("Relative absolute error", null),
    ROOT_RELATIVE_SQUARED_ERROR("Root relative squared error", null),
    CORRELATION_COEFFICIENT("Correlation coefficient", false),
    SF_PRIOR_ENTROPY("SF prior entropy", null),
    SF_SCHEME_ENTROPY("SF scheme entropy", null),
    SF_ENTROPY_GAIN("SF entropy gain", null),
    SF_MEAN_PRIOR_ENTROPY("SF mean prior entropy", null),
    SF_MEAN_SCHEME_ENTROPY("SF mean scheme entropy", null),
    SF_MEAN_ENTROPY_GAIN("SF mean entropy gain", null),
    KB_INFORMATION("KB information", true),
    KB_MEAN_INFORMATION("KB mean information", true),
    KB_RELATIVE_INFORMATION("KB relative information", true),
    TRUE_POSITIVE_RATE("True positive rate", true, true),
    NUM_TRUE_POSITIVES("Num true positives", true, true),
    FALSE_POSITIVE_RATE("False positive rate", true, true),
    NUM_FALSE_POSITIVES("Num false positives", true, true),
    TRUE_NEGATIVE_RATE("True negative rate", true, true),
    NUM_TRUE_NEGATIVES("Num true negatives", true, true),
    FALSE_NEGATIVE_RATE("False negative rate", true, true),
    NUM_FALSE_NEGATIVES("Num false negatives", true, true),
    IR_PRECISION("IR precision", true, true),
    IR_RECALL("IR recall", true, true),
    F_MEASURE("F measure", true, true),
    MATTHEWS_CORRELATION_COEFFICIENT("Matthews correlation coefficient", true, true),
    AREA_UNDER_ROC("Area under ROC", true, true),
    AREA_UNDER_PRC("Area under PRC", true, true),
    WEIGHTED_TRUE_POSITIVE_RATE("Weighted true positive rate", true),
    WEIGHTED_FALSE_POSITIVE_RATE("Weighted false positive rate", true),
    WEIGHTED_TRUE_NEGATIVE_RATE("Weighted true negative rate", true),
    WEIGHTED_FALSE_NEGATIVE_RATE("Weighted false negative rate", true),
    WEIGHTED_IR_PRECISION("Weighted IR precision", true),
    WEIGHTED_IR_RECALL("Weighted IR recall", true),
    WEIGHTED_F_MEASURE("Weighted F measure", true),
    WEIGHTED_MATTHEWS_CORRELATION_COEFFICIENT("Weighted Matthews correlation coefficient", true),
    WEIGHTED_AREA_UNDER_ROC("Weighted area under ROC", true),
    WEIGHTED_AREA_UNDER_PRC("Weighted area under PRC", true),
    UNWEIGHTED_MACRO_F_MEASURE("Unweighted Macro F measure", true),
    UNWEIGHTED_MICRO_F_MEASURE("Unweighted Micro F measure", true),
    BIAS("Bias", false),
    MSLE("Mean squared logarithmic error", false),
    RSQUARED("R^2", false),
    SDR("Standard Deviation of Residuals", false),
    RPD("Ratio of Performance to Deviation", false);

    private String m_Display;
    private String m_Raw;
    protected Boolean m_OnlyNominal;
    private boolean m_PerClass;

    private EvaluationStatistic(String display, Boolean onlyNominal) {
        this(display, onlyNominal, false);
    }

    private EvaluationStatistic(String display, Boolean onlyNominal, boolean perClass) {
        this.m_Display = display;
        this.m_Raw = super.toString();
        this.m_OnlyNominal = onlyNominal;
        this.m_PerClass = perClass;
    }

    public boolean isPerClass() {
        return this.m_PerClass;
    }

    public boolean isOnlyNominal() {
        return this.m_OnlyNominal != null && this.m_OnlyNominal != false;
    }

    public boolean isOnlyNumeric() {
        return this.m_OnlyNominal != null && this.m_OnlyNominal == false;
    }

    public String toDisplay() {
        Object result = this.m_Display;
        if (this.m_OnlyNominal != null) {
            result = this.m_OnlyNominal != false ? (String)result + " (nominal)" : (String)result + " (numeric)";
        }
        return result;
    }

    public String toDisplayShort() {
        return this.m_Display;
    }

    public String toRaw() {
        return this.m_Raw;
    }

    public EvaluationStatistic parse(String s) {
        return EvaluationStatistic.valueOf((AbstractOption)null, s);
    }

    public String getField() {
        return this.m_Display.replaceAll(" .*", "");
    }

    public String toString() {
        return this.m_Display;
    }

    public static String toString(AbstractOption option, Object object) {
        return ((EvaluationStatistic)((Object)object)).toRaw();
    }

    public static EvaluationStatistic valueOf(AbstractOption option, String str) {
        EvaluationStatistic result = null;
        try {
            result = EvaluationStatistic.valueOf(str);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (result == null) {
            for (EvaluationStatistic f : EvaluationStatistic.values()) {
                if (f.toDisplay().equals(str)) {
                    result = f;
                    break;
                }
                if (!f.toDisplayShort().equals(str)) continue;
                result = f;
                break;
            }
        }
        return result;
    }
}

