/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.QuickInfoHelper;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.sink.AbstractSink;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.File;
import javax.swing.DefaultListModel;
import weka.classifiers.Classifier;
import weka.experiment.CSVResultListener;
import weka.experiment.ClassifierSplitEvaluator;
import weka.experiment.CrossValidationResultProducer;
import weka.experiment.Experiment;
import weka.experiment.InstancesResultListener;
import weka.experiment.PropertyNode;
import weka.experiment.RandomSplitResultProducer;
import weka.experiment.RegressionSplitEvaluator;
import weka.experiment.ResultListener;
import weka.experiment.ResultProducer;
import weka.experiment.SplitEvaluator;

public class WekaExperimentGenerator
extends AbstractSink {
    private static final long serialVersionUID = -586416108746115363L;
    protected ExperimentType m_ExperimentType;
    protected EvaluationType m_EvaluationType;
    protected int m_Runs;
    protected int m_Folds;
    protected double m_SplitPercentage;
    protected ResultFormat m_ResultFormat;
    protected PlaceholderFile m_ResultFile;
    protected PlaceholderFile m_OutputFile;

    public String globalInfo() {
        return "Generates an experiment setup that can be used in conjunction with the Experiment transformer actor.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("exp-type", "experimentType", (Object)ExperimentType.CLASSIFICATION);
        this.m_OptionManager.add("eval-type", "evaluationType", (Object)EvaluationType.CROSS_VALIDATION);
        this.m_OptionManager.add("runs", "runs", (Object)10, (Number)1, null);
        this.m_OptionManager.add("folds", "folds", (Object)10, (Number)2, null);
        this.m_OptionManager.add("split", "splitPercentage", (Object)66.0, (Number)1.0E-4, (Number)99.9999);
        this.m_OptionManager.add("result-format", "resultFormat", (Object)ResultFormat.ARFF);
        this.m_OptionManager.add("result-file", "resultFile", (Object)new PlaceholderFile("."));
        this.m_OptionManager.add("output", "outputFile", (Object)new PlaceholderFile("."));
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"outputFile", (Object)this.m_OutputFile, (String)"Output: ");
    }

    public void setExperimentType(ExperimentType value) {
        this.m_ExperimentType = value;
        this.reset();
    }

    public ExperimentType getExperimentType() {
        return this.m_ExperimentType;
    }

    public String experimentTypeTipText() {
        return "The type of experiment to perform.";
    }

    public void setEvaluationType(EvaluationType value) {
        this.m_EvaluationType = value;
        this.reset();
    }

    public EvaluationType getEvaluationType() {
        return this.m_EvaluationType;
    }

    public String evaluationTypeTipText() {
        return "The type of evaluation to perform.";
    }

    public void setRuns(int value) {
        if (value >= 1) {
            this.m_Runs = value;
            this.reset();
        } else {
            this.getLogger().severe("At least 1 run must be performed, provided: " + value);
        }
    }

    public int getRuns() {
        return this.m_Runs;
    }

    public String runsTipText() {
        return "The number of runs to perform.";
    }

    public void setFolds(int value) {
        if (value > 1) {
            this.m_Folds = value;
            this.reset();
        } else {
            this.getLogger().severe("At least 2 folds are necessary, provided: " + value);
        }
    }

    public int getFolds() {
        return this.m_Folds;
    }

    public String foldsTipText() {
        return "The number of folds to use in cross-validation.";
    }

    public void setSplitPercentage(double value) {
        if (value > 0.0 && value < 100.0) {
            this.m_SplitPercentage = value;
            this.reset();
        } else {
            this.getLogger().severe("Split percentage must be 0 < x < 100, provided: " + value);
        }
    }

    public double getSplitPercentage() {
        return this.m_SplitPercentage;
    }

    public String splitPercentageTipText() {
        return "The percentage to use in train/test splits.";
    }

    public void setResultFormat(ResultFormat value) {
        this.m_ResultFormat = value;
        this.reset();
    }

    public ResultFormat getResultFormat() {
        return this.m_ResultFormat;
    }

    public String resultFormatTipText() {
        return "The data format the experimental results are stored in.";
    }

    public void setResultFile(PlaceholderFile value) {
        this.m_ResultFile = value;
        this.reset();
    }

    public PlaceholderFile getResultFile() {
        return this.m_ResultFile;
    }

    public String resultFileTipText() {
        return "The file to store the experimental results in.";
    }

    public void setOutputFile(PlaceholderFile value) {
        this.m_OutputFile = value;
        this.reset();
    }

    public PlaceholderFile getOutputFile() {
        return this.m_OutputFile;
    }

    public String outputFileTipText() {
        return "The file to store the experiment setup in (the extension determines the type).";
    }

    public Class[] accepts() {
        return new Class[]{Classifier[].class};
    }

    protected String doExecute() {
        Object result = null;
        if (this.m_ResultFile.isDirectory()) {
            result = "Result file points to a directory: " + this.m_ResultFile;
        } else if (this.m_OutputFile.isDirectory()) {
            result = "Output file points to a directory: " + this.m_OutputFile;
        }
        if (result == null) {
            Experiment exp = new Experiment();
            exp.setPropertyArray((Object)new Classifier[0]);
            exp.setUsePropertyIterator(true);
            ClassifierSplitEvaluator se = null;
            Classifier sec = null;
            if (this.m_ExperimentType == ExperimentType.CLASSIFICATION) {
                se = new ClassifierSplitEvaluator();
                sec = se.getClassifier();
            } else if (this.m_ExperimentType == ExperimentType.REGRESSION) {
                se = new RegressionSplitEvaluator();
                sec = ((RegressionSplitEvaluator)se).getClassifier();
            } else {
                throw new IllegalStateException("Unhandled experiment type: " + this.m_ExperimentType);
            }
            if (this.m_EvaluationType == EvaluationType.CROSS_VALIDATION) {
                CrossValidationResultProducer cvrp = new CrossValidationResultProducer();
                cvrp.setNumFolds(this.m_Folds);
                cvrp.setSplitEvaluator((SplitEvaluator)se);
                PropertyNode[] propertyPath = new PropertyNode[2];
                try {
                    propertyPath[0] = new PropertyNode((Object)se, new PropertyDescriptor("splitEvaluator", CrossValidationResultProducer.class), CrossValidationResultProducer.class);
                    propertyPath[1] = new PropertyNode((Object)sec, new PropertyDescriptor("classifier", se.getClass()), se.getClass());
                }
                catch (IntrospectionException e) {
                    e.printStackTrace();
                }
                exp.setResultProducer((ResultProducer)cvrp);
                exp.setPropertyPath(propertyPath);
            } else if (this.m_EvaluationType == EvaluationType.TRAIN_TEST_SPLIT_RANDOMIZED || this.m_EvaluationType == EvaluationType.TRAIN_TEST_SPLIT_ORDER_PRESERVED) {
                RandomSplitResultProducer rsrp = new RandomSplitResultProducer();
                rsrp.setRandomizeData(this.m_EvaluationType == EvaluationType.TRAIN_TEST_SPLIT_RANDOMIZED);
                rsrp.setTrainPercent(this.m_SplitPercentage);
                rsrp.setSplitEvaluator((SplitEvaluator)se);
                PropertyNode[] propertyPath = new PropertyNode[2];
                try {
                    propertyPath[0] = new PropertyNode((Object)se, new PropertyDescriptor("splitEvaluator", RandomSplitResultProducer.class), RandomSplitResultProducer.class);
                    propertyPath[1] = new PropertyNode((Object)sec, new PropertyDescriptor("classifier", se.getClass()), se.getClass());
                }
                catch (IntrospectionException e) {
                    e.printStackTrace();
                }
                exp.setResultProducer((ResultProducer)rsrp);
                exp.setPropertyPath(propertyPath);
            } else {
                throw new IllegalStateException("Unhandled evaluation type: " + this.m_EvaluationType);
            }
            exp.setRunLower(1);
            exp.setRunUpper(this.m_Runs);
            exp.setPropertyArray((Object)((Classifier[])this.m_InputToken.getPayload()));
            DefaultListModel model = new DefaultListModel();
            exp.setDatasets(model);
            if (this.m_ResultFormat == ResultFormat.ARFF) {
                InstancesResultListener irl = new InstancesResultListener();
                irl.setOutputFile(new File(this.m_ResultFile.getAbsolutePath()));
                exp.setResultListener((ResultListener)irl);
            } else if (this.m_ResultFormat == ResultFormat.CSV) {
                CSVResultListener crl = new CSVResultListener();
                crl.setOutputFile(new File(this.m_ResultFile.getAbsolutePath()));
                exp.setResultListener((ResultListener)crl);
            } else {
                throw new IllegalStateException("Unhandled result format: " + this.m_ResultFormat);
            }
            try {
                Experiment.write((String)this.m_OutputFile.getAbsolutePath(), (Experiment)exp);
            }
            catch (Exception e) {
                result = this.handleException("Failed to save experiment to '" + this.m_OutputFile + "': ", e);
            }
        }
        return result;
    }

    public static enum ResultFormat {
        ARFF,
        CSV;

    }

    public static enum EvaluationType {
        CROSS_VALIDATION,
        TRAIN_TEST_SPLIT_RANDOMIZED,
        TRAIN_TEST_SPLIT_ORDER_PRESERVED;

    }

    public static enum ExperimentType {
        CLASSIFICATION,
        REGRESSION;

    }
}

