/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.QuickInfoHelper;
import adams.core.Shortening;
import adams.core.io.FileUtils;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.flow.sink.AbstractFileWriter;
import java.io.File;
import weka.core.Instances;
import weka.core.converters.AbstractFileSaver;
import weka.core.converters.ConverterUtils;
import weka.core.converters.Saver;
import weka.core.converters.SimpleArffSaver;

public class WekaFileWriter
extends AbstractFileWriter {
    private static final long serialVersionUID = 7509908838736709270L;
    protected boolean m_UseRelationNameAsFilename;
    protected boolean m_UseCustomSaver;
    protected AbstractFileSaver m_CustomSaver;

    public String globalInfo() {
        return "Actor for saving a weka.core.Instances object as file.\nThe relation name of the incoming dataset can be used to replace the current filename (path and extension are kept). If the filename points to a directory, the relation name is simply appended.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("use-relation", "useRelationNameAsFilename", (Object)false);
        this.m_OptionManager.add("use-custom", "useCustomSaver", (Object)false);
        this.m_OptionManager.add("saver", "customSaver", (Object)new SimpleArffSaver());
    }

    public String outputFileTipText() {
        return "The filename of the dataset to write (the file extension determines the file format).";
    }

    public void setUseRelationNameAsFilename(boolean value) {
        this.m_UseRelationNameAsFilename = value;
        this.reset();
    }

    public boolean getUseRelationNameAsFilename() {
        return this.m_UseRelationNameAsFilename;
    }

    public String useRelationNameAsFilenameTipText() {
        return "If set to true, then the relation name replaces the name of the output file; eg if the output file is '/some/where/file.arff' and the relation is 'anneal' then the resulting file name will be '/some/where/anneal.arff'; if the file points to a directory, then the relation name is simple appended.";
    }

    public void setUseCustomSaver(boolean value) {
        this.m_UseCustomSaver = value;
        this.reset();
    }

    public boolean getUseCustomSaver() {
        return this.m_UseCustomSaver;
    }

    public String useCustomSaverTipText() {
        return "If set to true, then the custom saver will be used for saving the data.";
    }

    public void setCustomSaver(AbstractFileSaver value) {
        this.m_CustomSaver = value;
        this.reset();
    }

    public AbstractFileSaver getCustomSaver() {
        return this.m_CustomSaver;
    }

    public String customSaverTipText() {
        return "The custom saver to use if enabled.";
    }

    public String getQuickInfo() {
        String value;
        Object result = super.getQuickInfo();
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"useRelationNameAsFilename", (boolean)this.m_UseRelationNameAsFilename, (String)"relation name as filename", (String)", ");
        if ((QuickInfoHelper.hasVariable((OptionHandler)this, (String)"useCustomSaver") || this.m_UseCustomSaver) && (value = QuickInfoHelper.toString((OptionHandler)this, (String)"customSaver", (Object)Shortening.shortenEnd((String)OptionUtils.getShortCommandLine((Object)this.getCustomSaver()), (int)40), (String)", saver: ")) != null) {
            result = (String)result + value;
        }
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Instances.class};
    }

    protected String performSetUpChecks(boolean fromSetUp) {
        Object result = super.performSetUpChecks(fromSetUp);
        if (result == null && !this.m_UseCustomSaver && this.canPerformSetUpCheck(fromSetUp, "outputFile") && ConverterUtils.getSaverForFile((String)this.m_OutputFile.getAbsolutePath()) == null) {
            result = "Cannot determine converter for file '" + this.m_OutputFile.getAbsolutePath() + "'!";
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        Instances data = (Instances)this.m_InputToken.getPayload();
        Object filename = null;
        try {
            ConverterUtils.DataSink sink;
            filename = this.m_OutputFile.getAbsolutePath();
            if (this.m_UseRelationNameAsFilename) {
                File file = new File((String)filename);
                filename = file.isDirectory() ? file.getAbsolutePath() + File.separator + FileUtils.createFilename((String)data.relationName(), (String)"_") + file.getName().replaceAll(".*\\.", ".") : file.getParentFile().getAbsolutePath() + File.separator + FileUtils.createFilename((String)data.relationName(), (String)"_") + file.getName().replaceAll(".*\\.", ".");
            }
            if (this.m_UseCustomSaver) {
                this.m_CustomSaver.setFile(new File((String)filename));
                sink = new ConverterUtils.DataSink((Saver)this.m_CustomSaver);
            } else {
                sink = new ConverterUtils.DataSink((String)filename);
            }
            sink.write(data);
        }
        catch (Exception e) {
            result = this.handleException("Failed to save dataset to: " + (String)filename, e);
        }
        return result;
    }
}

