/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.weka.WekaAttributeRange;
import adams.flow.container.WekaEvaluationContainer;
import adams.flow.transformer.AbstractTransformer;
import java.util.ArrayList;
import java.util.logging.Level;
import weka.classifiers.Evaluation;
import weka.core.Instances;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Remove;

public abstract class AbstractWekaPredictionsTransformer
extends AbstractTransformer {
    private static final long serialVersionUID = 8682062846689759416L;
    protected boolean m_AddLabelIndex;
    protected boolean m_ShowError;
    protected boolean m_UseAbsoluteError;
    protected boolean m_ShowProbability;
    protected boolean m_ShowDistribution;
    protected boolean m_ShowWeight;
    protected boolean m_UseOriginalIndices;
    protected WekaAttributeRange m_TestAttributes;
    protected String m_MeasuresPrefix;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("add-index", "addLabelIndex", (Object)false);
        this.m_OptionManager.add("error", "showError", (Object)false);
        this.m_OptionManager.add("absolute-error", "useAbsoluteError", (Object)true);
        this.m_OptionManager.add("probability", "showProbability", (Object)false);
        this.m_OptionManager.add("distribution", "showDistribution", (Object)false);
        this.m_OptionManager.add("weight", "showWeight", (Object)false);
        this.m_OptionManager.add("use-original-indices", "useOriginalIndices", (Object)true);
        this.m_OptionManager.add("test-attributes", "testAttributes", (Object)new WekaAttributeRange(""));
        this.m_OptionManager.add("measures-prefix", "measuresPrefix", (Object)"");
    }

    public String getQuickInfo() {
        ArrayList options = new ArrayList();
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"addLabelIndex", (boolean)this.m_AddLabelIndex, (String)"label-index"));
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"showError", (boolean)this.m_ShowError, (String)"error"));
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"useAbsoluteError", (boolean)this.m_UseAbsoluteError, (String)"absolute error"));
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"showProbability", (boolean)this.m_ShowProbability, (String)"probability"));
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"showDistribution", (boolean)this.m_ShowDistribution, (String)"distribution"));
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"showWeight", (boolean)this.m_ShowWeight, (String)"weight"));
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"useOriginalWeights", (boolean)this.m_UseOriginalIndices, (String)"original indices"));
        String result = QuickInfoHelper.flatten(options);
        return result;
    }

    public void setAddLabelIndex(boolean value) {
        this.m_AddLabelIndex = value;
        this.reset();
    }

    public boolean getAddLabelIndex() {
        return this.m_AddLabelIndex;
    }

    public String addLabelIndexTipText() {
        return "If set to true, then the label is prefixed with the index.";
    }

    public void setShowError(boolean value) {
        this.m_ShowError = value;
        this.reset();
    }

    public boolean getShowError() {
        return this.m_ShowError;
    }

    public String showErrorTipText() {
        return "If set to true, then the error will be displayed as well.";
    }

    public void setUseAbsoluteError(boolean value) {
        this.m_UseAbsoluteError = value;
        this.reset();
    }

    public boolean getUseAbsoluteError() {
        return this.m_UseAbsoluteError;
    }

    public String useAbsoluteErrorTipText() {
        return "If set to true, then the error will be absolute (no direction).";
    }

    public void setShowProbability(boolean value) {
        this.m_ShowProbability = value;
        this.reset();
    }

    public boolean getShowProbability() {
        return this.m_ShowProbability;
    }

    public String showProbabilityTipText() {
        return "If set to true, then the probability of the prediction will be displayed as well (only for nominal class attributes).";
    }

    public void setShowDistribution(boolean value) {
        this.m_ShowDistribution = value;
        this.reset();
    }

    public boolean getShowDistribution() {
        return this.m_ShowDistribution;
    }

    public String showDistributionTipText() {
        return "If set to true, then the class distribution will be displayed as well (only for nominal class attributes).";
    }

    public void setShowWeight(boolean value) {
        this.m_ShowWeight = value;
        this.reset();
    }

    public boolean getShowWeight() {
        return this.m_ShowWeight;
    }

    public String showWeightTipText() {
        return "If set to true, then the instance weight will be displayed as well.";
    }

    public void setUseOriginalIndices(boolean value) {
        this.m_UseOriginalIndices = value;
        this.reset();
    }

    public boolean getUseOriginalIndices() {
        return this.m_UseOriginalIndices;
    }

    public String useOriginalIndicesTipText() {
        return "If set to true, the input token is a " + WekaEvaluationContainer.class.getName() + " and it contains the original indices ('Original indices') then the output will get aligned with the original data.";
    }

    public void setTestAttributes(WekaAttributeRange value) {
        this.m_TestAttributes = value;
        this.reset();
    }

    public WekaAttributeRange getTestAttributes() {
        return this.m_TestAttributes;
    }

    public String testAttributesTipText() {
        return "The range of attributes from the test set to add to the output (if test data available).";
    }

    public void setMeasuresPrefix(String value) {
        this.m_MeasuresPrefix = value;
        this.reset();
    }

    public String getMeasuresPrefix() {
        return this.m_MeasuresPrefix;
    }

    public String measuresPrefixTipText() {
        return "The prefix to use for the measure attributes being output.";
    }

    public Class[] accepts() {
        return new Class[]{Evaluation.class, WekaEvaluationContainer.class};
    }

    protected Instances filterTestData(Instances data) {
        try {
            this.m_TestAttributes.setData(data);
            int[] indices = this.m_TestAttributes.getIntIndices();
            Remove remove = new Remove();
            remove.setAttributeIndicesArray(indices);
            remove.setInvertSelection(true);
            remove.setInputFormat(data);
            return Filter.useFilter((Instances)data, (Filter)remove);
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to filter test data using range: " + this.m_TestAttributes.getRange(), (Throwable)e);
            return null;
        }
    }
}

