/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.container.WekaClusterEvaluationContainer;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import weka.clusterers.ClusterEvaluation;

public class WekaClusterAssignments
extends AbstractTransformer {
    private static final long serialVersionUID = 8082115424369061977L;

    public String globalInfo() {
        return "Outputs the cluster assignments from the evaluation.";
    }

    public Class[] accepts() {
        return new Class[]{ClusterEvaluation.class, WekaClusterEvaluationContainer.class};
    }

    public Class[] generates() {
        return new Class[]{SpreadSheet.class};
    }

    protected String doExecute() {
        String result = null;
        ClusterEvaluation eval = this.m_InputToken.getPayload() instanceof WekaClusterEvaluationContainer ? (ClusterEvaluation)((WekaClusterEvaluationContainer)((Object)this.m_InputToken.getPayload())).getValue("Evaluation") : (ClusterEvaluation)this.m_InputToken.getPayload();
        if (eval != null && eval.getClusterAssignments() != null) {
            DefaultSpreadSheet sheet = new DefaultSpreadSheet();
            sheet.getHeaderRow().addCell("A").setContent("Assignment");
            for (double assignment : eval.getClusterAssignments()) {
                sheet.addRow().addCell("A").setContent(Double.valueOf(assignment));
            }
            this.m_OutputToken = new Token((Object)sheet);
        } else {
            this.getLogger().warning("No evaluation or cluster assignments available!");
        }
        return result;
    }
}

