/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.ClassCrossReference;
import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.flow.container.WekaModelContainer;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.WekaTrainClusterer;
import adams.flow.transformer.wekaclusterer.AbstractClustererPostProcessor;
import adams.flow.transformer.wekaclusterer.PassThrough;

public class WekaClustererPostProcessor
extends AbstractTransformer
implements ClassCrossReference {
    private static final long serialVersionUID = -3019442578354930841L;
    protected AbstractClustererPostProcessor m_PostProcessor;

    public String globalInfo() {
        String result = "Applies the specified post-processor to the cluster container (" + Utils.classToString(WekaModelContainer.class) + ").";
        String additional = this.m_PostProcessor.getAdditionalInformation();
        if (!additional.isEmpty()) {
            result = result + "\n\nPost-processor information:\n" + additional;
        }
        return result;
    }

    public Class[] getClassCrossReferences() {
        return new Class[]{WekaTrainClusterer.class};
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("post-processor", "postProcessor", (Object)new PassThrough());
    }

    public void setPostProcessor(AbstractClustererPostProcessor value) {
        this.m_PostProcessor = value;
        this.reset();
    }

    public AbstractClustererPostProcessor getPostProcessor() {
        return this.m_PostProcessor;
    }

    public String postProcessorTipText() {
        return "The post-processor to use.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"postProcessor", (Object)((Object)this.m_PostProcessor), (String)"post-processor: ");
    }

    public Class[] accepts() {
        return new Class[]{WekaModelContainer.class};
    }

    public Class[] generates() {
        return new Class[]{WekaModelContainer.class};
    }

    protected String doExecute() {
        String result = null;
        try {
            WekaModelContainer cont = (WekaModelContainer)((Object)this.m_InputToken.getPayload(WekaModelContainer.class));
            cont = this.m_PostProcessor.postProcess(cont);
            this.m_OutputToken = new Token((Object)cont);
        }
        catch (Exception e) {
            this.m_OutputToken = null;
            result = this.handleException("Failed to process cluster container: " + this.m_InputToken.getPayload(), e);
        }
        return result;
    }
}

