/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.weka.datasetsplitter.AbstractSplitter;
import adams.data.weka.datasetsplitter.RowSplitter;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import weka.core.Instances;

public class WekaDatasetSplit
extends AbstractTransformer {
    private static final long serialVersionUID = -2718426142990052207L;
    protected AbstractSplitter m_Splitter;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("splitter", "splitter", (Object)new RowSplitter());
    }

    public AbstractSplitter getSplitter() {
        return this.m_Splitter;
    }

    public void setSplitter(AbstractSplitter value) {
        this.m_Splitter = value;
        this.reset();
    }

    public String splitterTipText() {
        return "The splitter to use to split the dataset.";
    }

    protected String doExecute() {
        try {
            Instances dataset = (Instances)this.m_InputToken.getPayload();
            Instances[] result = this.m_Splitter.split(dataset);
            this.m_OutputToken = new Token();
            this.m_OutputToken.setPayload((Object)result);
            return null;
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    public String globalInfo() {
        return "Splits the incoming dataset into sub-sets using the specified splitter.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"splitter", (Object)((Object)this.m_Splitter), (String)"splitter: ");
    }

    public Class[] accepts() {
        return new Class[]{Instances.class};
    }

    public Class[] generates() {
        return new Class[]{Instances[].class};
    }
}

