/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.container.WekaEvaluationContainer;
import adams.flow.transformer.AbstractArrayProvider;
import adams.flow.transformer.wekaevaluationpostprocessor.AbstractWekaEvaluationPostProcessor;
import adams.flow.transformer.wekaevaluationpostprocessor.PassThrough;
import java.util.List;
import weka.classifiers.Evaluation;

public class WekaEvaluationPostProcessor
extends AbstractArrayProvider {
    private static final long serialVersionUID = -8135722038751549524L;
    protected AbstractWekaEvaluationPostProcessor m_PostProcessor;

    public String globalInfo() {
        return "Applies the specified post-processor to the incoming Evaluation data.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("post-processor", "postProcessor", (Object)new PassThrough());
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"postProcessor", (Object)((Object)this.m_PostProcessor));
    }

    public void setPostProcessor(AbstractWekaEvaluationPostProcessor value) {
        this.m_PostProcessor = value;
        this.reset();
    }

    public AbstractWekaEvaluationPostProcessor getPostProcessor() {
        return this.m_PostProcessor;
    }

    public String postProcessorTipText() {
        return "The post-processor to apply to the incoming Evaluation data.";
    }

    public Class[] accepts() {
        return new Class[]{Evaluation.class, WekaEvaluationContainer.class};
    }

    protected Class getItemClass() {
        return WekaEvaluationContainer.class;
    }

    public String outputArrayTipText() {
        return "If enabled, outputs the " + WekaEvaluationContainer.class.getName() + " objects as array instead of one-by-one.";
    }

    protected String doExecute() {
        String result = null;
        this.m_Queue.clear();
        WekaEvaluationContainer cont = this.m_InputToken.getPayload() instanceof Evaluation ? new WekaEvaluationContainer((Evaluation)this.m_InputToken.getPayload()) : (WekaEvaluationContainer)((Object)this.m_InputToken.getPayload());
        try {
            List<WekaEvaluationContainer> processed = this.m_PostProcessor.postProcess(cont);
            this.m_Queue.addAll(processed);
        }
        catch (Exception e) {
            result = this.handleException("Failed to post-process Evaluation data!", e);
        }
        return result;
    }
}

