/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.weka.WekaLabelRange;
import adams.flow.container.WekaEvaluationContainer;
import adams.flow.core.EvaluationHelper;
import adams.flow.core.EvaluationStatistic;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import weka.classifiers.Evaluation;

public class WekaEvaluationValues
extends AbstractTransformer {
    private static final long serialVersionUID = -1977976026411517458L;
    protected EvaluationStatistic[] m_StatisticValues;
    protected WekaLabelRange m_ClassIndex;

    public String globalInfo() {
        return "Generates a spreadsheet from statistics of an Evaluation object.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("statistic", "statisticValues", (Object)new EvaluationStatistic[]{EvaluationStatistic.PERCENT_CORRECT, EvaluationStatistic.ROOT_MEAN_SQUARED_ERROR, EvaluationStatistic.ROOT_RELATIVE_SQUARED_ERROR});
        this.m_OptionManager.add("index", "classIndex", (Object)new WekaLabelRange("first"));
    }

    public void setStatisticValues(EvaluationStatistic[] value) {
        this.m_StatisticValues = value;
        this.reset();
    }

    public EvaluationStatistic[] getStatisticValues() {
        return this.m_StatisticValues;
    }

    public String statisticValuesTipText() {
        return "The evaluation values to extract and turn into a spreadsheet.";
    }

    public void setClassIndex(WekaLabelRange value) {
        this.m_ClassIndex = value;
        this.reset();
    }

    public WekaLabelRange getClassIndex() {
        return this.m_ClassIndex;
    }

    public String classIndexTipText() {
        return "The range of class label indices (eg used for AUC).";
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"classIndex", (Object)((Object)this.m_ClassIndex), (String)"Labels: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"statisticValues", (Object)(this.m_StatisticValues.length + " value" + (this.m_StatisticValues.length != 1 ? "s" : "")), (String)", ");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Evaluation.class, WekaEvaluationContainer.class};
    }

    protected String addStatistic(Evaluation eval, SpreadSheet sheet, EvaluationStatistic statistic, int classIndex, boolean useIndex) {
        String result = null;
        try {
            double value = EvaluationHelper.getValue(eval, statistic, classIndex);
            DataRow row = sheet.addRow();
            Object name = statistic.toDisplayShort();
            if (useIndex && statistic.isPerClass()) {
                name = (String)name + " (" + eval.getHeader().classAttribute().value(classIndex) + ")";
            }
            row.addCell(0).setContent((String)name);
            row.addCell(1).setContent(Double.toString(value));
        }
        catch (Exception e) {
            result = this.handleException("Error retrieving value for '" + statistic + "':\n", e);
        }
        return result;
    }

    protected String doExecute() {
        Object result = null;
        Evaluation eval = this.m_InputToken.getPayload() instanceof WekaEvaluationContainer ? (Evaluation)((WekaEvaluationContainer)((Object)this.m_InputToken.getPayload())).getValue("Evaluation") : (Evaluation)this.m_InputToken.getPayload();
        this.m_ClassIndex.setData(eval.getHeader().classAttribute());
        int[] indices = this.m_ClassIndex.getIntIndices();
        DefaultSpreadSheet sheet = new DefaultSpreadSheet();
        sheet.getHeaderRow().addCell("0").setContent("Statistic");
        sheet.getHeaderRow().addCell("1").setContent("Value");
        if (indices.length <= 1) {
            for (EvaluationStatistic statistic : this.m_StatisticValues) {
                String msg = this.addStatistic(eval, (SpreadSheet)sheet, statistic, indices.length == 0 ? 0 : indices[0], true);
                if (msg == null) continue;
                result = result == null ? "" : (String)result + "\n";
                result = (String)result + msg;
            }
        } else if (indices.length > 1) {
            String msg;
            for (EvaluationStatistic statistic : this.m_StatisticValues) {
                if (statistic.isPerClass() || (msg = this.addStatistic(eval, (SpreadSheet)sheet, statistic, 0, false)) == null) continue;
                result = result == null ? "" : (String)result + "\n";
                result = (String)result + msg;
            }
            for (int index : indices) {
                for (EvaluationStatistic statistic : this.m_StatisticValues) {
                    if (!statistic.isPerClass() || (msg = this.addStatistic(eval, (SpreadSheet)sheet, statistic, index, true)) == null) continue;
                    result = result == null ? "" : (String)result + "\n";
                    result = (String)result + msg;
                }
            }
        }
        this.m_OutputToken = new Token((Object)sheet);
        return result;
    }

    public Class[] generates() {
        return new Class[]{SpreadSheet.class};
    }
}

