/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseString;
import adams.core.classmanager.ClassManager;
import adams.core.option.OptionHandler;
import adams.flow.core.ExperimentStatistic;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import weka.core.Attribute;
import weka.core.Instances;
import weka.core.Range;
import weka.core.converters.ConverterUtils;
import weka.experiment.CSVResultListener;
import weka.experiment.DatabaseResultListener;
import weka.experiment.Experiment;
import weka.experiment.InstanceQuery;
import weka.experiment.PairedCorrectedTTester;
import weka.experiment.ResultMatrix;
import weka.experiment.Tester;
import weka.gui.experiment.ExperimenterDefaults;

public class WekaExperimentEvaluation
extends AbstractTransformer {
    private static final long serialVersionUID = -8186675646383734197L;
    protected Tester m_Tester;
    protected ExperimentStatistic m_ComparisonField;
    protected double m_Significance;
    protected int m_TestBase;
    protected BaseString[] m_Row;
    protected BaseString[] m_Column;
    protected boolean m_SwapRowsAndColumns;
    protected ResultMatrix m_OutputFormat;
    protected boolean m_OutputHeader;

    public String globalInfo() {
        return "Generates evaluation output of an experiment that was run previously.";
    }

    public void defineOptions() {
        int i;
        super.defineOptions();
        this.m_OptionManager.add("tester", "tester", (Object)new PairedCorrectedTTester());
        this.m_OptionManager.add("comparison", "comparisonField", (Object)ExperimentStatistic.PERCENT_CORRECT);
        this.m_OptionManager.add("significance", "significance", (Object)0.05, (Number)1.0E-4, (Number)0.9999);
        this.m_OptionManager.add("test", "testBase", (Object)0, (Number)0, null);
        String[] list = ExperimenterDefaults.getRow().split(",");
        BaseString[] str = new BaseString[list.length];
        for (i = 0; i < list.length; ++i) {
            str[i] = new BaseString(list[i]);
        }
        this.m_OptionManager.add("row", "row", (Object)str);
        list = ExperimenterDefaults.getColumn().split(",");
        str = new BaseString[list.length];
        for (i = 0; i < list.length; ++i) {
            str[i] = new BaseString(list[i]);
        }
        this.m_OptionManager.add("col", "column", (Object)str);
        this.m_OptionManager.add("swap", "swapRowsAndColumns", (Object)false);
        this.m_OptionManager.add("format", "outputFormat", (Object)ExperimenterDefaults.getOutputFormat());
        this.m_OptionManager.add("header", "outputHeader", (Object)true);
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"comparisonField", (Object)((Object)this.m_ComparisonField));
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"outputFormat", this.m_OutputFormat.getClass(), (String)", format: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"swapRowsAndColumns", (boolean)this.m_SwapRowsAndColumns, (String)"swapped", (String)", ");
        return result;
    }

    public void setTester(Tester value) {
        this.m_Tester = value;
        this.reset();
    }

    public Tester getTester() {
        return this.m_Tester;
    }

    public String testerTipText() {
        return "The testing algorithm to use for performing the evaluations.";
    }

    public void setComparisonField(ExperimentStatistic value) {
        this.m_ComparisonField = value;
        this.reset();
    }

    public ExperimentStatistic getComparisonField() {
        return this.m_ComparisonField;
    }

    public String comparisonFieldTipText() {
        return "The field to base the comparison of algorithms on.";
    }

    public void setSignificance(double value) {
        this.m_Significance = value;
        this.reset();
    }

    public double getSignificance() {
        return this.m_Significance;
    }

    public String significanceTipText() {
        return "The significance level (0-1).";
    }

    public void setTestBase(int value) {
        this.m_TestBase = value;
        this.reset();
    }

    public int getTestBase() {
        return this.m_TestBase;
    }

    public String testBaseTipText() {
        return "The index of the test base (normally the first classifier, ie '0').";
    }

    public void setRow(BaseString[] value) {
        this.m_Row = value;
        this.reset();
    }

    public BaseString[] getRow() {
        return this.m_Row;
    }

    public String rowTipText() {
        return "The list of fields that define a row (normally the dataset).";
    }

    public void setColumn(BaseString[] value) {
        this.m_Column = value;
        this.reset();
    }

    public BaseString[] getColumn() {
        return this.m_Column;
    }

    public String columnTipText() {
        return "The list of fields that define a column (normally the schemes).";
    }

    public void setSwapRowsAndColumns(boolean value) {
        this.m_SwapRowsAndColumns = value;
        this.reset();
    }

    public boolean getSwapRowsAndColumns() {
        return this.m_SwapRowsAndColumns;
    }

    public String swapRowsAndColumnsTipText() {
        return "If set to true, rows and columns will be swapped.";
    }

    public void setOutputFormat(ResultMatrix value) {
        this.m_OutputFormat = value;
        this.reset();
    }

    public ResultMatrix getOutputFormat() {
        return this.m_OutputFormat;
    }

    public String outputFormatTipText() {
        return "The output format for generating the output.";
    }

    public void setOutputHeader(boolean value) {
        this.m_OutputHeader = value;
        this.reset();
    }

    public boolean getOutputHeader() {
        return this.m_OutputHeader;
    }

    public String outputHeaderTipText() {
        return "If set to true, then a header describing the experiment evaluation will get output as well.";
    }

    public Class[] accepts() {
        return new Class[]{Experiment.class, Instances.class};
    }

    protected List<String> determineColumnNames(BaseString[] list, String defaultList) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < list.length; ++i) {
            result.add(list[i].stringValue().toLowerCase());
        }
        if (result.size() == 0) {
            StringTokenizer tok = new StringTokenizer(defaultList, ",");
            while (tok.hasMoreTokens()) {
                result.add(tok.nextToken().toLowerCase());
            }
        }
        return result;
    }

    protected Instances getData(Experiment exp) throws Exception {
        Instances result;
        if (exp.getResultListener() instanceof CSVResultListener) {
            try {
                result = ConverterUtils.DataSource.read((String)((CSVResultListener)exp.getResultListener()).getOutputFile().getAbsolutePath());
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Failed to get instances from CSV:", (Throwable)e);
                throw new Exception("Error reading experiment from file:\n" + e);
            }
        } else if (exp.getResultListener() instanceof DatabaseResultListener) {
            DatabaseResultListener dbListener = (DatabaseResultListener)exp.getResultListener();
            try {
                String tmpStr = dbListener.getResultsTableName(exp.getResultProducer());
                InstanceQuery query = new InstanceQuery();
                query.setDatabaseURL(dbListener.getDatabaseURL());
                query.setUsername(dbListener.getUsername());
                query.setPassword(dbListener.getPassword());
                query.setDebug(dbListener.getDebug());
                query.connectToDatabase();
                result = query.retrieveInstances("SELECT * FROM " + tmpStr);
                query.disconnectFromDatabase();
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Failed to get instances from database:", (Throwable)e);
                throw new Exception("Error reading experiment from database:\n" + e);
            }
        } else {
            throw new Exception("Unsupported ResultListener '" + exp.getResultListener().getClass().getName() + "'!");
        }
        return result;
    }

    protected Tester getTester(Instances data) throws Exception {
        List<String> cols;
        List<String> rows;
        Tester ttester = (Tester)ClassManager.getSingleton().deepCopy((Object)this.m_Tester);
        ResultMatrix matrix = (ResultMatrix)ClassManager.getSingleton().deepCopy((Object)this.m_OutputFormat);
        ttester.setInstances(data);
        ttester.setSignificanceLevel(this.m_Significance);
        ttester.setShowStdDevs(matrix.getShowStdDev());
        ttester.setSortColumn(-1);
        if (!this.m_SwapRowsAndColumns) {
            rows = this.determineColumnNames(this.m_Row, ExperimenterDefaults.getRow());
            cols = this.determineColumnNames(this.m_Column, ExperimenterDefaults.getColumn());
        } else {
            cols = this.determineColumnNames(this.m_Row, ExperimenterDefaults.getRow());
            rows = this.determineColumnNames(this.m_Column, ExperimenterDefaults.getColumn());
        }
        Object selectedList = "";
        Object selectedListDataset = "";
        boolean comparisonFieldSet = false;
        for (int i = 0; i < data.numAttributes(); ++i) {
            String name = data.attribute(i).name();
            if (rows.contains(name.toLowerCase())) {
                selectedListDataset = (String)selectedListDataset + "," + (i + 1);
                continue;
            }
            if (name.toLowerCase().equals("key_run")) {
                ttester.setRunColumn(i);
                continue;
            }
            if (name.toLowerCase().equals("key_fold")) {
                ttester.setFoldColumn(i);
                continue;
            }
            if (cols.contains(name.toLowerCase())) {
                selectedList = (String)selectedList + "," + (i + 1);
                continue;
            }
            if (name.toLowerCase().contains(ExperimenterDefaults.getComparisonField())) {
                comparisonFieldSet = true;
                continue;
            }
            if (!name.toLowerCase().contains("root_relative_squared_error") || comparisonFieldSet) continue;
            comparisonFieldSet = true;
        }
        Range generatorRange = new Range();
        if (((String)selectedList).length() != 0) {
            try {
                generatorRange.setRanges((String)selectedList);
            }
            catch (Exception ex) {
                this.handleException("Failed to set ranges: " + (String)selectedList, ex);
            }
        }
        ttester.setResultsetKeyColumns(generatorRange);
        generatorRange = new Range();
        if (((String)selectedListDataset).length() != 0) {
            try {
                generatorRange.setRanges((String)selectedListDataset);
            }
            catch (Exception ex) {
                this.handleException("Failed to set dataset ranges: " + (String)selectedListDataset, ex);
            }
        }
        ttester.setDatasetKeyColumns(generatorRange);
        String tmpStr = this.m_ComparisonField.getField();
        Attribute att = data.attribute(tmpStr);
        if (att == null) {
            throw new Exception("Cannot find comparison field '" + tmpStr + "' in data!");
        }
        ttester.setDisplayedResultsets(null);
        ttester.setResultMatrix(matrix);
        return ttester;
    }

    protected void evaluateExperiment(Instances data) throws Exception {
        Tester ttester = this.getTester(data);
        String tmpStr = this.m_ComparisonField.getField();
        Attribute att = data.attribute(tmpStr);
        if (att == null) {
            throw new Exception("Cannot find comparison field '" + tmpStr + "' in data!");
        }
        int compareCol = att.index();
        int tType = this.m_TestBase;
        StringBuilder outBuff = new StringBuilder();
        if (this.m_OutputHeader) {
            outBuff.append(ttester.header(compareCol));
            outBuff.append("\n");
        }
        try {
            if (tType < ttester.getNumResultsets()) {
                outBuff.append(ttester.multiResultsetFull(tType, compareCol));
            } else if (tType == ttester.getNumResultsets()) {
                outBuff.append(ttester.multiResultsetSummary(compareCol));
            } else {
                outBuff.append(ttester.multiResultsetRanking(compareCol));
            }
            outBuff.append("\n");
        }
        catch (Exception ex) {
            outBuff.append(ex.getMessage() + "\n");
        }
        this.m_OutputToken = new Token((Object)outBuff.toString());
    }

    protected String doExecute() {
        String result = null;
        try {
            if (this.m_InputToken.getPayload() instanceof Experiment) {
                this.evaluateExperiment(this.getData((Experiment)this.m_InputToken.getPayload()));
            } else {
                this.evaluateExperiment((Instances)this.m_InputToken.getPayload());
            }
        }
        catch (Exception e) {
            result = this.handleException("Error evaluating the experiment: ", e);
        }
        return result;
    }

    public Class[] generates() {
        return new Class[]{String.class};
    }
}

