/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Index;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import weka.core.Instances;

public class WekaExtractArray
extends AbstractTransformer {
    private static final long serialVersionUID = -3989993009528522476L;
    protected ExtractionType m_Type;
    protected Index m_Index;

    public String globalInfo() {
        return "Extracts a column or row of data from a weka.core.Instances or SpreadSheet object.\nOnly numeric columns can be returned. In case of row-retrieval, the value of the internal format of the weka.core.Instance object is returned; for SpreadSheet object it is attempted to convert the cell content to double (null values might get returned!).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type", "type", (Object)ExtractionType.COLUMN);
        this.m_OptionManager.add("index", "index", (Object)new Index("first"));
    }

    protected void initialize() {
        super.initialize();
        this.m_Index = new Index();
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"type", (Object)((Object)this.m_Type));
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"index", (Object)this.m_Index, (String)": ");
        return result;
    }

    public void setType(ExtractionType value) {
        this.m_Type = value;
        this.reset();
    }

    public ExtractionType getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of extraction to perform, row or column.";
    }

    public void setIndex(Index value) {
        this.m_Index = value;
        this.reset();
    }

    public Index getIndex() {
        return this.m_Index;
    }

    public String indexTipText() {
        return "The index of the row/column to extract.";
    }

    public Class[] accepts() {
        return new Class[]{Instances.class, SpreadSheet.class};
    }

    public Class[] generates() {
        return new Class[]{Double[].class};
    }

    protected String doExecute() {
        String result = null;
        Double[] array = null;
        if (this.m_InputToken.getPayload() instanceof Instances) {
            Instances inst = (Instances)this.m_InputToken.getPayload();
            if (this.m_Type == ExtractionType.COLUMN) {
                this.m_Index.setMax(inst.numAttributes());
            } else {
                this.m_Index.setMax(inst.numInstances());
            }
            int index = this.m_Index.getIntIndex();
            if (index == -1) {
                result = "Invalid index: " + this.m_Index + " (max=" + this.m_Index.getMax() + ")";
            } else if (this.m_Type == ExtractionType.COLUMN && !inst.attribute(index).isNumeric()) {
                result = "Column " + this.m_Index + " is not numeric!";
            }
            if (result == null) {
                if (this.m_Type == ExtractionType.COLUMN) {
                    array = new Double[inst.numInstances()];
                    for (int i = 0; i < array.length; ++i) {
                        array[i] = inst.instance(i).value(index);
                    }
                } else {
                    array = new Double[inst.numAttributes()];
                    for (int i = 0; i < array.length; ++i) {
                        array[i] = inst.instance(index).value(i);
                    }
                }
            }
        } else {
            SpreadSheet sheet = (SpreadSheet)this.m_InputToken.getPayload();
            if (this.m_Type == ExtractionType.COLUMN) {
                this.m_Index.setMax(sheet.getColumnCount());
            } else {
                this.m_Index.setMax(sheet.getRowCount());
            }
            int index = this.m_Index.getIntIndex();
            if (index == -1) {
                result = "Invalid index: " + this.m_Index + " (max=" + this.m_Index.getMax() + ")";
            } else if (this.m_Type == ExtractionType.COLUMN && !sheet.isNumeric(index, true)) {
                result = "Column " + this.m_Index + " is not numeric!";
            }
            if (result == null) {
                if (this.m_Type == ExtractionType.COLUMN) {
                    array = new Double[sheet.getRowCount()];
                    for (int i = 0; i < array.length; ++i) {
                        Cell cell = sheet.getCell(i, index);
                        if (cell == null || cell.isMissing()) continue;
                        array[i] = cell.toDouble();
                    }
                } else {
                    array = new Double[sheet.getColumnCount()];
                    for (int i = 0; i < array.length; ++i) {
                        Cell cell = sheet.getCell(index, i);
                        if (cell == null || cell.isMissing()) continue;
                        array[i] = cell.toDouble();
                    }
                }
            }
        }
        if (array != null) {
            this.m_OutputToken = new Token(array);
        }
        return result;
    }

    public static enum ExtractionType {
        COLUMN,
        ROW;

    }
}

