/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Shortening;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.converters.AArffLoader;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.ConverterUtils;
import weka.core.converters.Loader;
import weka.core.converters.SimpleArffLoader;
import weka.core.converters.URLSourcedLoader;

public class WekaFileReader
extends AbstractTransformer {
    private static final long serialVersionUID = 9097157984356638281L;
    public static final String BACKUP_STRUCTURE = "structure";
    public static final String BACKUP_SOURCE = "source";
    protected boolean m_UseCustomLoader;
    protected AbstractFileLoader m_CustomLoader;
    protected OutputType m_OutputType;
    protected Instances m_Structure;
    protected ConverterUtils.DataSource m_Source;

    public String globalInfo() {
        return "Reads any file format that Weka's converters can handle and returns the full dataset or single weka.core.Instance objects. This actor takes the file or URL to read as input. In case of URLs, the associated loader must implement " + URLSourcedLoader.class.getName() + ".";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("use-custom", "useCustomLoader", (Object)false);
        this.m_OptionManager.add("loader", "customLoader", (Object)new SimpleArffLoader());
        this.m_OptionManager.add("output-type", "outputType", (Object)OutputType.DATASET);
    }

    public String getQuickInfo() {
        Object result = null;
        result = QuickInfoHelper.hasVariable((OptionHandler)this, (String)"useCustomLoader") || this.m_UseCustomLoader ? QuickInfoHelper.toString((OptionHandler)this, (String)"loader", (Object)Shortening.shortenEnd((String)OptionUtils.getShortCommandLine((Object)this.getCustomLoader()), (int)40)) : "automatic";
        result = (String)result + " (" + QuickInfoHelper.toString((OptionHandler)this, (String)"outputType", (Object)((Object)this.m_OutputType)) + ")";
        return result;
    }

    public Class[] accepts() {
        ArrayList<Class<URL>> result = new ArrayList<Class<URL>>();
        result.add(String.class);
        result.add(File.class);
        if (this.getUseCustomLoader()) {
            if (this.getCustomLoader() instanceof URLSourcedLoader) {
                result.add(URL.class);
            }
        } else {
            result.add(URL.class);
        }
        return result.toArray(new Class[result.size()]);
    }

    public Class[] generates() {
        if (this.m_OutputType == OutputType.INCREMENTAL) {
            return new Class[]{Instance.class};
        }
        return new Class[]{Instances.class};
    }

    public void setUseCustomLoader(boolean value) {
        this.m_UseCustomLoader = value;
        this.reset();
    }

    public boolean getUseCustomLoader() {
        return this.m_UseCustomLoader;
    }

    public String useCustomLoaderTipText() {
        return "If set to true, then the custom loader will be used for loading the data.";
    }

    public void setCustomLoader(AbstractFileLoader value) {
        this.m_CustomLoader = value;
        this.reset();
    }

    public AbstractFileLoader getCustomLoader() {
        return this.m_CustomLoader;
    }

    public String customLoaderTipText() {
        return "The custom loader to use if enabled.";
    }

    public void setOutputType(OutputType value) {
        this.m_OutputType = value;
        this.reset();
    }

    public OutputType getOutputType() {
        return this.m_OutputType;
    }

    public String outputTypeTipText() {
        return "Defines how the data is output, e.g., as complete dataset or row-by-row.";
    }

    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_STRUCTURE);
        this.pruneBackup(BACKUP_SOURCE);
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        if (this.m_Structure != null) {
            result.put(BACKUP_STRUCTURE, this.m_Structure);
        }
        if (this.m_Source != null) {
            result.put(BACKUP_SOURCE, this.m_Source);
        }
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_STRUCTURE)) {
            this.m_Structure = (Instances)state.get(BACKUP_STRUCTURE);
            state.remove(BACKUP_STRUCTURE);
        }
        if (state.containsKey(BACKUP_SOURCE)) {
            this.m_Source = (ConverterUtils.DataSource)state.get(BACKUP_SOURCE);
            state.remove(BACKUP_SOURCE);
        }
        super.restoreState(state);
    }

    protected void reset() {
        super.reset();
        this.m_Structure = null;
        this.m_Source = null;
    }

    protected String doExecute() {
        String result = null;
        try {
            boolean isArff;
            String ext;
            Object obj = this.m_InputToken.getPayload();
            String[] exts = FileUtils.getExtensions((String)obj.toString().toLowerCase());
            if (exts != null && exts.length > 0) {
                ext = exts[0];
                isArff = ext.equals("arff") || ext.equals("arff.gz");
            } else {
                ext = "";
                isArff = false;
            }
            File file = null;
            URL url = null;
            if (obj instanceof File) {
                file = new File(((File)obj).getAbsolutePath());
            } else if (obj instanceof URL) {
                url = (URL)obj;
            } else {
                file = new File(new PlaceholderFile((String)obj).getAbsolutePath());
            }
            this.m_Source = null;
            if (this.m_UseCustomLoader) {
                AbstractFileLoader loader = this.m_CustomLoader;
                if (url != null) {
                    ((URLSourcedLoader)loader).setURL(url.toString());
                } else {
                    loader.setFile(file);
                }
                this.m_Source = new ConverterUtils.DataSource((Loader)loader);
            } else if (ext.isEmpty()) {
                result = "File has no extension to be used by file type detection, but no custom loader defined!";
            } else if (isArff) {
                Object loader;
                if (url != null) {
                    loader = new AArffLoader();
                    ((URLSourcedLoader)loader).setURL(url.toString());
                } else {
                    loader = new SimpleArffLoader();
                    loader.setFile(file);
                }
                this.m_Source = new ConverterUtils.DataSource((Loader)loader);
            } else {
                this.m_Source = url != null ? new ConverterUtils.DataSource(url.toString()) : new ConverterUtils.DataSource(file.getAbsolutePath());
            }
            if (this.m_Source != null) {
                this.m_Structure = this.m_Source.getStructure();
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to load data from: " + this.m_InputToken.getPayload(), e);
        }
        return result;
    }

    public Token output() {
        Token result;
        switch (this.m_OutputType) {
            case DATASET: {
                try {
                    result = new Token((Object)this.m_Source.getDataSet());
                }
                catch (Exception e) {
                    result = null;
                    this.handleException("Failed to get dataset:", e);
                }
                this.m_Structure = null;
                this.m_Source = null;
                break;
            }
            case HEADER: {
                result = new Token((Object)this.m_Structure);
                this.m_Structure = null;
                this.m_Source = null;
                break;
            }
            case INCREMENTAL: {
                result = new Token((Object)this.m_Source.nextElement(this.m_Structure));
                if (this.m_Source.hasMoreElements(this.m_Structure)) break;
                this.m_Structure = null;
                this.m_Source = null;
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled output type: " + this.m_OutputType);
            }
        }
        return result;
    }

    public boolean hasPendingOutput() {
        switch (this.m_OutputType) {
            case INCREMENTAL: {
                return this.m_Structure != null && this.m_Source.hasMoreElements(this.m_Structure);
            }
        }
        return this.m_Structure != null;
    }

    public void wrapUp() {
        this.m_Structure = null;
        this.m_Source = null;
        super.wrapUp();
    }

    public static enum OutputType {
        DATASET,
        HEADER,
        INCREMENTAL;

    }
}

