/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.flow.container.WekaGeneticAlgorithmInitializationContainer;
import adams.flow.control.StorageName;
import adams.flow.control.StorageUser;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.opt.genetic.AbstractClassifierBasedGeneticAlgorithm;
import java.util.Properties;
import weka.core.Instances;

public class WekaGeneticAlgorithmInitializer
extends AbstractTransformer
implements StorageUser {
    private static final long serialVersionUID = 5071747277597147724L;
    protected StorageName m_StorageName;
    protected String m_Setup;
    protected String m_Weights;

    public String globalInfo() {
        return "Populates a " + WekaGeneticAlgorithmInitializationContainer.class.getName() + " container from the data obtained from the incoming setup (in properties format, can be gzip compressed).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("storage-name", "storageName", (Object)new StorageName());
        this.m_OptionManager.add("setup", "setup", (Object)"Commandline");
        this.m_OptionManager.add("weights", "weights", (Object)"Weights");
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"storageName", (Object)this.m_StorageName, (String)"data: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"setup", (Object)this.m_Setup, (String)", setup: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"weights", (Object)this.m_Weights, (String)", weights: ");
        return result;
    }

    public void setStorageName(StorageName value) {
        this.m_StorageName = value;
        this.reset();
    }

    public StorageName getStorageName() {
        return this.m_StorageName;
    }

    public String storageNameTipText() {
        return "The name of the data in internal storage.";
    }

    public void setSetup(String value) {
        this.m_Setup = value;
        this.reset();
    }

    public String getSetup() {
        return this.m_Setup;
    }

    public String setupTipText() {
        return "The property in the incoming properties that contains the commandline of the genetic algorithm.";
    }

    public void setWeights(String value) {
        this.m_Weights = value;
        this.reset();
    }

    public String getWeights() {
        return this.m_Weights;
    }

    public String weightsTipText() {
        return "The optional weights property in the incoming properties for initializing the algorithm.";
    }

    public boolean isUsingStorage() {
        return !this.getSkip();
    }

    public Class[] accepts() {
        return new Class[]{String.class, Properties.class};
    }

    public Class[] generates() {
        return new Class[]{WekaGeneticAlgorithmInitializationContainer.class};
    }

    protected String doExecute() {
        Instances data;
        adams.core.Properties aprops;
        Object result = null;
        WekaGeneticAlgorithmInitializationContainer cont = null;
        if (this.m_InputToken.getPayload() instanceof String) {
            aprops = new adams.core.Properties();
            aprops.load((String)this.m_InputToken.getPayload());
        } else {
            Properties props = (Properties)this.m_InputToken.getPayload();
            aprops = props instanceof adams.core.Properties ? (adams.core.Properties)props : new adams.core.Properties(props);
        }
        String cmdline = null;
        if (aprops.hasKey(this.m_Setup)) {
            cmdline = aprops.getProperty(this.m_Setup);
        } else {
            result = "Failed to locate property '" + this.m_Setup + "'!";
        }
        String weights = null;
        if (aprops.hasKey(this.m_Weights)) {
            weights = aprops.getProperty(this.m_Weights);
        }
        if ((data = (Instances)this.getStorageHandler().getStorage().get(this.m_StorageName)) == null) {
            result = "Failed to obtain training data from '" + this.m_StorageName + "'!";
        }
        if (result == null) {
            try {
                AbstractClassifierBasedGeneticAlgorithm algorithm = (AbstractClassifierBasedGeneticAlgorithm)((Object)OptionUtils.forAnyCommandLine(AbstractClassifierBasedGeneticAlgorithm.class, (String)cmdline));
                if (weights != null) {
                    algorithm.setInitialWeights(weights);
                }
                cont = new WekaGeneticAlgorithmInitializationContainer(algorithm, data);
            }
            catch (Exception e) {
                result = this.handleException("Failed to instantiate genetic algorithm: " + cmdline, e);
            }
        }
        if (cont != null) {
            this.m_OutputToken = new Token(cont);
        }
        return result;
    }
}

