/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Index;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.weka.WekaAttributeIndex;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import weka.core.Instances;

public class WekaGetInstancesValue
extends AbstractTransformer {
    private static final long serialVersionUID = -3057815118900209749L;
    protected Index m_Row;
    protected WekaAttributeIndex m_Column;

    public String globalInfo() {
        return "Retrieves a value from a WEKA Instances object.\nNotes:\n- date and relational values are forwarded as strings\n- missing values are output as '?' (without the single quotes)\n";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("row", "row", (Object)new Index("first"));
        this.m_OptionManager.add("column", "column", (Object)new WekaAttributeIndex("first"));
    }

    protected void initialize() {
        super.initialize();
        this.m_Row = new Index("first");
        this.m_Column = new WekaAttributeIndex("first");
    }

    public void setRow(Index value) {
        this.m_Row = value;
        this.reset();
    }

    public Index getRow() {
        return this.m_Row;
    }

    public String rowTipText() {
        return "The 1-based index of the row.";
    }

    public void setColumn(WekaAttributeIndex value) {
        this.m_Column = value;
        this.reset();
    }

    public WekaAttributeIndex getColumn() {
        return this.m_Column;
    }

    public String columnTipText() {
        return "The column to set get the value from.";
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"column", (Object)((Object)this.m_Column), (String)"col: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"row", (Object)this.m_Row, (String)", row: ");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Instances.class};
    }

    public Class[] generates() {
        return new Class[]{Double.class, String.class};
    }

    protected String doExecute() {
        Object result = null;
        Instances inst = (Instances)this.m_InputToken.getPayload();
        this.m_Column.setData(inst);
        this.m_Row.setMax(inst.numInstances());
        int index = this.m_Column.getIntIndex();
        int row = this.m_Row.getIntIndex();
        if (row == -1) {
            result = "Failed to retrieve row: " + this.m_Row.getIndex();
        } else if (index == -1) {
            result = "Failed to retrieve column: " + this.m_Column.getIndex();
        }
        if (result == null) {
            try {
                if (inst.instance(row).isMissing(index)) {
                    this.m_OutputToken = new Token((Object)"?");
                } else {
                    switch (inst.attribute(index).type()) {
                        case 0: {
                            this.m_OutputToken = new Token((Object)inst.instance(row).value(index));
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: {
                            this.m_OutputToken = new Token((Object)inst.instance(row).stringValue(index));
                            break;
                        }
                        default: {
                            result = "Unhandled attribute type: " + inst.attribute(index).type();
                        }
                    }
                }
            }
            catch (Exception e) {
                result = this.handleException("Failed to obtain value from dataset:", e);
            }
        }
        return result;
    }
}

