/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.weka.evaluator.AbstractDatasetInstanceEvaluator;
import adams.data.weka.evaluator.AbstractInstanceEvaluator;
import adams.data.weka.evaluator.PassThrough;
import adams.flow.core.CallableActorReference;
import adams.flow.core.Compatibility;
import adams.flow.core.Token;
import adams.flow.source.CallableSource;
import adams.flow.transformer.AbstractTransformer;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.SelectedTag;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Add;

public class WekaInstanceEvaluator
extends AbstractTransformer {
    private static final long serialVersionUID = -8810671831368685057L;
    public static final String ATTRIBUTE_NAME = "evaluation";
    protected AbstractInstanceEvaluator m_Evaluator;
    protected CallableActorReference m_InstancesActor;
    protected Instances m_Header;
    protected String m_AttributeName;
    protected CallableSource m_GlobalSource;
    protected Add m_Filter;

    public String globalInfo() {
        return "Adds a new attribute to the data being passed through (normally 'evaluation') and sets the value to the evaluation value returned by the chosen evaluator scheme.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("evaluator", "evaluator", (Object)new PassThrough());
        this.m_OptionManager.add("instances", "instancesActor", (Object)new CallableActorReference(""));
    }

    protected void reset() {
        super.reset();
        this.m_Header = null;
        this.m_AttributeName = null;
        this.m_GlobalSource = null;
        this.m_Filter = null;
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"evaluator", (Object)(this.m_Evaluator instanceof AbstractDatasetInstanceEvaluator ? this.m_AttributeName : null));
    }

    public void setEvaluator(AbstractInstanceEvaluator value) {
        this.m_Evaluator = value;
        this.reset();
    }

    public AbstractInstanceEvaluator getEvaluator() {
        return this.m_Evaluator;
    }

    public String evaluatorTipText() {
        return "The evaluator to use.";
    }

    public void setInstancesActor(CallableActorReference value) {
        this.m_InstancesActor = value;
        this.reset();
    }

    public CallableActorReference getInstancesActor() {
        return this.m_InstancesActor;
    }

    public String instancesActorTipText() {
        return "The name of the callable actor from which to retrieve Instances in case of " + AbstractDatasetInstanceEvaluator.class.getName() + "-derived classes,";
    }

    public Class[] accepts() {
        return new Class[]{Instance.class};
    }

    public Class[] generates() {
        return new Class[]{Instance.class};
    }

    public String setUp() {
        Object result = super.setUp();
        if (result == null && this.m_Evaluator instanceof AbstractDatasetInstanceEvaluator) {
            if (this.m_InstancesActor.toString().length() == 0) {
                result = "No callable actor defined for obtaining the dataset from to initialize the evaluator with!";
            } else {
                Compatibility comp;
                this.m_GlobalSource = new CallableSource();
                this.m_GlobalSource.setParent(this.getParent());
                this.m_GlobalSource.setCallableName(this.m_InstancesActor);
                result = this.m_GlobalSource.setUp();
                if (result == null && !(comp = new Compatibility()).isCompatible(this.m_GlobalSource.generates(), new Class[]{Instances.class})) {
                    result = "Global actor '" + this.m_InstancesActor + "' does not produce weka.core.Instances!";
                }
            }
        }
        return result;
    }

    protected String determineAttributeName(Instances data) {
        Object result = ATTRIBUTE_NAME;
        int i = 0;
        while (data.attribute((String)result) != null) {
            result = ATTRIBUTE_NAME + ++i;
        }
        this.m_AttributeName = result;
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Chosen attribute name: " + this.m_AttributeName);
        }
        return result;
    }

    protected String setUpEvaluator() {
        Object result = null;
        if (this.m_Evaluator instanceof AbstractDatasetInstanceEvaluator && (result = this.m_GlobalSource.execute()) == null) {
            if (!this.m_GlobalSource.hasPendingOutput()) {
                result = "Global actor '" + this.m_InstancesActor + "' did not produce weka.core.Instances!";
            } else {
                Instances data = (Instances)this.m_GlobalSource.output().getPayload();
                ((AbstractDatasetInstanceEvaluator)this.m_Evaluator).setData(data);
            }
        }
        return result;
    }

    protected String generateHeader(Instance inst) {
        String result = null;
        this.m_Filter = new Add();
        this.m_Filter.setAttributeName(this.determineAttributeName(inst.dataset()));
        this.m_Filter.setAttributeType(new SelectedTag(0, Add.TAGS_TYPE));
        if (inst.dataset().classIndex() == inst.dataset().numAttributes() - 1) {
            this.m_Filter.setAttributeIndex("" + inst.dataset().numAttributes());
        } else {
            this.m_Filter.setAttributeIndex("" + (inst.dataset().numAttributes() + 1));
        }
        try {
            this.m_Filter.setInputFormat(inst.dataset());
            this.m_Header = Filter.useFilter((Instances)inst.dataset(), (Filter)this.m_Filter);
        }
        catch (Exception e) {
            result = this.handleException("Failed to generate header:", e);
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        Instance inst = (Instance)this.m_InputToken.getPayload();
        if (this.m_Header == null) {
            result = this.setUpEvaluator();
        }
        if (result == null && this.m_Header == null) {
            result = this.generateHeader(inst);
        }
        if (result == null) {
            try {
                double eval = this.m_Evaluator.evaluate(inst);
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("Evaluation " + eval + " for instance: " + inst);
                }
                this.m_Filter.input(inst);
                this.m_Filter.batchFinished();
                Instance newInst = this.m_Filter.output();
                newInst.setValue(newInst.dataset().attribute(this.m_AttributeName), eval);
                this.m_OutputToken = new Token((Object)newInst);
            }
            catch (Exception e) {
                this.m_OutputToken = null;
                result = this.handleException("Failed to evaluate instance: " + inst, e);
            }
        }
        return result;
    }

    public void wrapUp() {
        this.m_Filter = null;
        this.m_Header = null;
        this.m_GlobalSource = null;
        super.wrapUp();
    }
}

