/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.ObjectCopyHelper;
import adams.core.QuickInfoHelper;
import adams.core.VariableName;
import adams.core.option.OptionHandler;
import adams.event.VariableChangeEvent;
import adams.flow.container.WekaNearestNeighborSearchContainer;
import adams.flow.control.StorageName;
import adams.flow.control.StorageUser;
import adams.flow.core.Token;
import adams.flow.core.VariableMonitor;
import adams.flow.transformer.AbstractTransformer;
import java.util.Hashtable;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.neighboursearch.LinearNNSearch;
import weka.core.neighboursearch.NearestNeighbourSearch;

public class WekaNearestNeighborSearch
extends AbstractTransformer
implements StorageUser,
VariableMonitor {
    private static final long serialVersionUID = -5495087922726994088L;
    public static final String BACKUP_SEARCH = "search";
    protected NearestNeighbourSearch m_Search;
    protected NearestNeighbourSearch m_ActualSearch;
    protected int m_MaxNeighbors;
    protected StorageName m_Storage;
    protected VariableName m_VariableName;

    public String globalInfo() {
        return "Outputs the specified number of nearest neighbors for the incoming Weka Instance.\nThe data used for the nearest neighbor search is either obtained from storage.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add(BACKUP_SEARCH, BACKUP_SEARCH, (Object)new LinearNNSearch());
        this.m_OptionManager.add("max-neighbors", "maxNeighbors", (Object)10, (Number)1, null);
        this.m_OptionManager.add("storage", "storage", (Object)new StorageName());
        this.m_OptionManager.add("var-name", "variableName", (Object)new VariableName());
    }

    protected void reset() {
        super.reset();
        this.m_ActualSearch = null;
    }

    public void setSearch(NearestNeighbourSearch value) {
        this.m_Search = value;
        this.reset();
    }

    public NearestNeighbourSearch getSearch() {
        return this.m_Search;
    }

    public String searchTipText() {
        return "The search algorithm to use.";
    }

    public void setMaxNeighbors(int value) {
        this.m_MaxNeighbors = value;
        this.reset();
    }

    public int getMaxNeighbors() {
        return this.m_MaxNeighbors;
    }

    public String maxNeighborsTipText() {
        return "The maximum number of neighbors to find.";
    }

    public void setStorage(StorageName value) {
        this.m_Storage = value;
        this.reset();
    }

    public StorageName getStorage() {
        return this.m_Storage;
    }

    public String storageTipText() {
        return "The storage item to obtain the data from.";
    }

    public void setVariableName(VariableName value) {
        this.m_VariableName = value;
        this.reset();
    }

    public VariableName getVariableName() {
        return this.m_VariableName;
    }

    public String variableNameTipText() {
        return "The variable to monitor.";
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)BACKUP_SEARCH, this.m_Search.getClass(), (String)"search: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"storage", (Object)this.m_Storage, (String)", storage: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"variableName", (Object)this.m_VariableName.paddedValue(), (String)", variable: ");
        return result;
    }

    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_SEARCH);
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        if (this.m_ActualSearch != null) {
            result.put(BACKUP_SEARCH, this.m_ActualSearch);
        }
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_SEARCH)) {
            this.m_ActualSearch = (NearestNeighbourSearch)state.get(BACKUP_SEARCH);
            state.remove(BACKUP_SEARCH);
        }
        super.restoreState(state);
    }

    public void variableChanged(VariableChangeEvent e) {
        super.variableChanged(e);
        if ((e.getType() == VariableChangeEvent.Type.MODIFIED || e.getType() == VariableChangeEvent.Type.ADDED) && e.getName().equals(this.m_VariableName.getValue())) {
            this.m_ActualSearch = null;
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Reset search algorithm");
            }
        }
    }

    public boolean isUsingStorage() {
        return !this.getSkip();
    }

    public Class[] accepts() {
        return new Class[]{Instance.class};
    }

    public Class[] generates() {
        return new Class[]{WekaNearestNeighborSearchContainer.class};
    }

    protected String doExecute() {
        Object result = null;
        if (this.m_ActualSearch == null) {
            try {
                this.m_ActualSearch = (NearestNeighbourSearch)ObjectCopyHelper.copyObject((Object)this.m_Search);
            }
            catch (Exception e) {
                result = this.handleException("Failed to create copy of search algorithm!", e);
            }
            if (result == null) {
                Instances data = (Instances)this.getStorageHandler().getStorage().get(this.m_Storage);
                if (data == null) {
                    result = "No data available: " + this.m_Storage;
                } else {
                    try {
                        this.m_ActualSearch.setInstances(data);
                    }
                    catch (Exception e) {
                        result = this.handleException("Failed to initialize search algorithm!", e);
                    }
                }
            }
        }
        if (result == null) {
            Instance inst = (Instance)this.m_InputToken.getPayload();
            try {
                Instances hood = this.m_ActualSearch.kNearestNeighbours(inst, this.m_MaxNeighbors);
                double[] distances = this.m_ActualSearch.getDistances();
                this.m_OutputToken = new Token((Object)new WekaNearestNeighborSearchContainer(inst, hood, distances));
            }
            catch (Exception e) {
                result = this.handleException("Failed to determine neighbors for: " + inst, e);
            }
        }
        return result;
    }
}

