/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.ClassCrossReference;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.statistics.StatUtils;
import adams.flow.container.WekaEvaluationContainer;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractWekaPredictionsTransformer;
import adams.flow.transformer.WekaSpreadSheetToPredictions;
import adams.ml.data.InstancesView;
import java.util.ArrayList;
import weka.classifiers.CrossValidationHelper;
import weka.classifiers.Evaluation;
import weka.classifiers.evaluation.NominalPrediction;
import weka.classifiers.evaluation.Prediction;
import weka.core.Instances;

public class WekaPredictionsToSpreadSheet
extends AbstractWekaPredictionsTransformer
implements ClassCrossReference {
    private static final long serialVersionUID = -1552754008462778501L;

    public String globalInfo() {
        return "Generates a SpreadSheet object from the predictions of an Evaluation object.";
    }

    public Class[] getClassCrossReferences() {
        return new Class[]{WekaSpreadSheetToPredictions.class};
    }

    protected String doExecute() {
        Instances testData;
        int[] indices;
        Evaluation eval;
        String result = null;
        if (this.m_InputToken.getPayload() instanceof WekaEvaluationContainer) {
            eval = (Evaluation)((WekaEvaluationContainer)((Object)this.m_InputToken.getPayload())).getValue("Evaluation");
            indices = (int[])((WekaEvaluationContainer)((Object)this.m_InputToken.getPayload())).getValue("Original indices");
            testData = (Instances)((WekaEvaluationContainer)((Object)this.m_InputToken.getPayload())).getValue("Test data");
        } else {
            eval = (Evaluation)this.m_InputToken.getPayload();
            indices = null;
            testData = null;
        }
        Instances header = eval.getHeader();
        boolean nominal = header.classAttribute().isNominal();
        ArrayList<Prediction> predictions = eval.predictions();
        if (predictions != null) {
            int n;
            DefaultSpreadSheet data = new DefaultSpreadSheet();
            data.setName("Predictions");
            HeaderRow row = data.getHeaderRow();
            row.addCell("A").setContent(this.m_MeasuresPrefix + "Actual");
            row.addCell("P").setContent(this.m_MeasuresPrefix + "Predicted");
            int indexErr = -1;
            if (this.m_ShowError) {
                indexErr = row.getCellCount();
                row.addCell("E").setContent(this.m_MeasuresPrefix + "Error");
            }
            int indexProb = -1;
            if (this.m_ShowProbability && nominal) {
                indexProb = row.getCellCount();
                row.addCell("Pr").setContent(this.m_MeasuresPrefix + "Probability");
            }
            int indexDist = -1;
            if (this.m_ShowDistribution && nominal) {
                indexDist = row.getCellCount();
                for (n = 0; n < header.classAttribute().numValues(); ++n) {
                    row.addCell("D" + n).setContent(this.m_MeasuresPrefix + "Distribution (" + header.classAttribute().value(n) + ")");
                }
            }
            int indexWeight = -1;
            if (this.m_ShowWeight) {
                indexWeight = row.getCellCount();
                row.addCell("W").setContent(this.m_MeasuresPrefix + "Weight");
            }
            if (indices != null && this.m_UseOriginalIndices) {
                predictions = CrossValidationHelper.alignPredictions(predictions, indices);
            }
            for (int i = 0; i < predictions.size(); ++i) {
                Prediction pred = predictions.get(i);
                row = data.addRow();
                if (Double.isNaN(pred.actual())) {
                    row.addCell(0).setMissing();
                } else if (nominal) {
                    row.addCell(0).setContentAsString(header.classAttribute().value((int)pred.actual()));
                } else {
                    row.addCell(0).setContent(Double.valueOf(pred.actual()));
                }
                if (Double.isNaN(pred.predicted())) {
                    row.addCell(1).setMissing();
                } else if (nominal) {
                    row.addCell(1).setContentAsString(header.classAttribute().value((int)pred.predicted()));
                } else {
                    row.addCell(1).setContent(Double.valueOf(pred.predicted()));
                }
                if (this.m_ShowError) {
                    if (nominal) {
                        row.addCell(indexErr).setContent(pred.actual() != pred.predicted() ? "true" : "false");
                    } else if (this.m_UseAbsoluteError) {
                        row.addCell(indexErr).setContent(Double.valueOf(Math.abs(pred.actual() - pred.predicted())));
                    } else {
                        row.addCell(indexErr).setContent(Double.valueOf(pred.actual() - pred.predicted()));
                    }
                }
                if (this.m_ShowProbability && nominal) {
                    row.addCell(indexProb).setContent(Double.valueOf(StatUtils.max((double[])((NominalPrediction)pred).distribution())));
                }
                if (this.m_ShowDistribution && nominal) {
                    for (n = 0; n < header.classAttribute().numValues(); ++n) {
                        row.addCell(indexDist + n).setContent(Double.valueOf(((NominalPrediction)pred).distribution()[n]));
                    }
                }
                if (!this.m_ShowWeight) continue;
                row.addCell(indexWeight).setContent(Double.valueOf(pred.weight()));
            }
            if (testData != null && !this.m_TestAttributes.isEmpty() && (testData = this.filterTestData(testData)) != null) {
                InstancesView testView = new InstancesView(testData);
                data.mergeWith((SpreadSheet)testView);
            }
            this.m_OutputToken = new Token((Object)data);
        } else {
            this.getLogger().severe("No predictions available from Evaluation object!");
        }
        return result;
    }

    public Class[] generates() {
        return new Class[]{SpreadSheet.class};
    }
}

