/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.ClassCrossReference;
import adams.core.DefaultCompare;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.data.spreadsheet.SpreadSheetUnorderedColumnRange;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.WekaPredictionsToSpreadSheet;
import java.io.Serializable;
import java.util.Comparator;
import weka.classifiers.AggregateEvaluations;
import weka.classifiers.Evaluation;

public class WekaSpreadSheetToPredictions
extends AbstractTransformer
implements ClassCrossReference {
    private static final long serialVersionUID = -2097531874480331676L;
    protected SpreadSheetColumnIndex m_Actual;
    protected SpreadSheetColumnIndex m_Predicted;
    protected SpreadSheetUnorderedColumnRange m_ClassDistribution;
    protected boolean m_UseColumnNamesAsClassLabels;
    protected SpreadSheetColumnIndex m_Weight;
    protected boolean m_SortLabels;
    protected Comparator m_Comparator;
    protected boolean m_Reverse;

    public String globalInfo() {
        return "Turns the predictions stored in the incoming spreadsheet (actual and predicted) into a Weka " + Evaluation.class.getName() + " object.\nFor recreating the predictions of a nominal class, the class distributions must be present in the spreadsheet as well.";
    }

    public Class[] getClassCrossReferences() {
        return new Class[]{WekaPredictionsToSpreadSheet.class};
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("actual", "actual", (Object)new SpreadSheetColumnIndex("Actual"));
        this.m_OptionManager.add("predicted", "predicted", (Object)new SpreadSheetColumnIndex("Predicted"));
        this.m_OptionManager.add("class-distribution", "classDistribution", (Object)new SpreadSheetUnorderedColumnRange(""));
        this.m_OptionManager.add("column-names-as-class-labels", "useColumnNamesAsClassLabels", (Object)false);
        this.m_OptionManager.add("weight", "weight", (Object)new SpreadSheetColumnIndex(""));
        this.m_OptionManager.add("sort-labels", "sortLabels", (Object)false);
        this.m_OptionManager.add("comparator", "comparator", (Object)new DefaultCompare());
        this.m_OptionManager.add("reverse", "reverse", (Object)false);
    }

    public void setActual(SpreadSheetColumnIndex value) {
        this.m_Actual = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getActual() {
        return this.m_Actual;
    }

    public String actualTipText() {
        return "The column with the actual values.";
    }

    public void setPredicted(SpreadSheetColumnIndex value) {
        this.m_Predicted = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getPredicted() {
        return this.m_Predicted;
    }

    public String predictedTipText() {
        return "The column with the predicted values.";
    }

    public void setClassDistribution(SpreadSheetUnorderedColumnRange value) {
        this.m_ClassDistribution = value;
        this.reset();
    }

    public SpreadSheetUnorderedColumnRange getClassDistribution() {
        return this.m_ClassDistribution;
    }

    public String classDistributionTipText() {
        return "The columns containing the class distribution (nominal class).";
    }

    public void setUseColumnNamesAsClassLabels(boolean value) {
        this.m_UseColumnNamesAsClassLabels = value;
        this.reset();
    }

    public boolean getUseColumnNamesAsClassLabels() {
        return this.m_UseColumnNamesAsClassLabels;
    }

    public String useColumnNamesAsClassLabelsTipText() {
        return "If enabled, the names of the class distribution columns are used as labels in the fake evaluation; automatically removes the surrounding 'Distribution (...)'.";
    }

    public void setWeight(SpreadSheetColumnIndex value) {
        this.m_Weight = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getWeight() {
        return this.m_Weight;
    }

    public String weightTipText() {
        return "The (optional) column with the weights of the instances; 1.0 is assumed by default.";
    }

    public void setSortLabels(boolean value) {
        this.m_SortLabels = value;
        this.reset();
    }

    public boolean getSortLabels() {
        return this.m_SortLabels;
    }

    public String sortLabelsTipText() {
        return "If enabled, the labels get sorted with the specified comparator.";
    }

    public void setComparator(Comparator value) {
        this.m_Comparator = value;
        this.reset();
    }

    public Comparator getComparator() {
        return this.m_Comparator;
    }

    public String comparatorTipText() {
        return "The comparator to use; must implement " + Comparator.class.getName() + " and " + Serializable.class.getName();
    }

    public void setReverse(boolean value) {
        this.m_Reverse = value;
        this.reset();
    }

    public boolean getReverse() {
        return this.m_Reverse;
    }

    public String reverseTipText() {
        return "If enabled, the sorting order gets reversed.";
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"actual", (Object)this.m_Actual, (String)"actual: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"predicted", (Object)this.m_Predicted, (String)", predicted: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"classDistribution", (Object)(this.m_ClassDistribution.isEmpty() ? "-none-" : this.m_ClassDistribution.getRange()), (String)", class: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"weight", (Object)(this.m_Weight.isEmpty() ? "-none-" : this.m_Weight.getIndex()), (String)", weight: ");
        if (this.m_SortLabels) {
            result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"comparator", (Object)this.m_Comparator, (String)", sort: ");
            result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"reverse", (boolean)this.m_Reverse, (String)"reverse", (String)", ");
        }
        return result;
    }

    public Class[] accepts() {
        return new Class[]{SpreadSheet.class};
    }

    public Class[] generates() {
        return new Class[]{Evaluation.class};
    }

    protected String doExecute() {
        Object result = null;
        SpreadSheet sheet = (SpreadSheet)this.m_InputToken.getPayload();
        this.m_Actual.setData((Object)sheet);
        this.m_Predicted.setData((Object)sheet);
        this.m_ClassDistribution.setData((Object)sheet);
        this.m_Weight.setData((Object)sheet);
        if (this.m_Actual.getIntIndex() == -1) {
            result = "'Actual' column not found: " + this.m_Actual;
        } else if (this.m_Predicted.getIntIndex() == -1) {
            result = "'Predicted' column not found: " + this.m_Predicted;
        }
        if (result == null) {
            AggregateEvaluations aggregate = new AggregateEvaluations();
            aggregate.setSortLabels(this.m_SortLabels);
            aggregate.setComparator(this.m_Comparator);
            aggregate.setReverse(this.m_Reverse);
            result = aggregate.add(sheet, this.m_Actual.getIntIndex(), this.m_Predicted.getIntIndex(), this.m_Weight.getIntIndex(), this.m_ClassDistribution.getIntIndices(), this.m_UseColumnNamesAsClassLabels);
            if (result == null) {
                Evaluation agg = aggregate.aggregated();
                if (agg == null) {
                    result = aggregate.hasLastError() ? aggregate.getLastError() : "Failed to aggregate predictions!";
                }
                if (agg != null) {
                    this.m_OutputToken = new Token((Object)agg);
                }
            }
        }
        return result;
    }
}

