/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.instance.Instance;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformerWithPropertiesUpdating;
import java.util.Hashtable;
import weka.core.Instances;
import weka.filters.Filter;
import weka.filters.StreamableFilter;
import weka.filters.unsupervised.attribute.Add;

public class WekaStreamFilter
extends AbstractTransformerWithPropertiesUpdating {
    private static final long serialVersionUID = 9078845385089445202L;
    public static final String BACKUP_INITIALIZED = "initialized";
    protected StreamableFilter m_Filter;
    protected boolean m_KeepRelationName;
    protected boolean m_Initialized;

    public String globalInfo() {
        return "Filters Instance objects using the specified filter.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("filter", "filter", (Object)new Add());
        this.m_OptionManager.add("keep", "keepRelationName", (Object)false);
    }

    public void setFilter(StreamableFilter value) {
        this.m_Filter = value;
        this.reset();
    }

    public StreamableFilter getFilter() {
        return this.m_Filter;
    }

    public String filterTipText() {
        return "The stream filter to use for filtering the Instance objects.";
    }

    public void setKeepRelationName(boolean value) {
        this.m_KeepRelationName = value;
        this.reset();
    }

    public boolean getKeepRelationName() {
        return this.m_KeepRelationName;
    }

    public String keepRelationNameTipText() {
        return "If set to true, then the filter won't change the relation name of the incoming dataset.";
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"filter", this.m_Filter.getClass());
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"keepRelationName", (boolean)this.m_KeepRelationName, (String)"keep relation name", (String)", ");
        String info = super.getQuickInfo();
        if (!info.isEmpty()) {
            result = (String)result + ", " + info;
        }
        return result;
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        result.put(BACKUP_INITIALIZED, this.m_Initialized);
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_INITIALIZED)) {
            this.m_Initialized = (Boolean)state.get(BACKUP_INITIALIZED);
            state.remove(BACKUP_INITIALIZED);
        }
        super.restoreState(state);
    }

    protected void reset() {
        super.reset();
        this.m_Initialized = false;
    }

    public Class[] accepts() {
        return new Class[]{weka.core.Instance.class, Instances.class, Instance.class};
    }

    public Class[] generates() {
        return new Class[]{weka.core.Instance.class, Instances.class, Instance.class};
    }

    protected String doExecute() {
        String result = null;
        weka.core.Instance inst = null;
        Instances data = null;
        weka.core.Instance filteredInst = null;
        Instances filteredData = null;
        Filter filter = (Filter)this.m_Filter;
        if (this.m_InputToken.getPayload() instanceof weka.core.Instance) {
            inst = (weka.core.Instance)this.m_InputToken.getPayload();
        } else if (this.m_InputToken.getPayload() instanceof Instances) {
            data = (Instances)this.m_InputToken.getPayload();
        } else {
            inst = ((Instance)((Object)this.m_InputToken.getPayload())).toInstance();
        }
        if (data == null) {
            data = inst.dataset();
        }
        try {
            if (!this.m_Initialized) {
                result = this.setUpContainers(filter);
                if (result == null) {
                    result = this.updateObject(filter);
                }
                filter.setInputFormat(new Instances(data, 0));
            }
            if (result == null) {
                String relation = data.relationName();
                if (inst == null) {
                    filteredData = Filter.useFilter((Instances)data, (Filter)filter);
                    if (this.m_KeepRelationName) {
                        filteredData.setRelationName(relation);
                    }
                } else {
                    filter.input(inst);
                    filter.batchFinished();
                    filteredInst = filter.output();
                    if (this.m_KeepRelationName) {
                        filteredInst.dataset().setRelationName(relation);
                    }
                }
                if (this.m_InputToken.getPayload() instanceof weka.core.Instance) {
                    this.m_OutputToken = new Token((Object)filteredInst);
                } else if (this.m_InputToken.getPayload() instanceof Instances) {
                    this.m_OutputToken = new Token((Object)filteredData);
                } else {
                    Instance instA = new Instance();
                    instA.set(filteredInst);
                    this.m_OutputToken = new Token((Object)instA);
                }
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to filter data: ", e);
        }
        return result;
    }
}

