/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.indexedsplitsrunsevaluation;

import adams.core.MessageCollection;
import adams.core.ObjectCopyHelper;
import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.data.indexedsplits.IndexedSplit;
import adams.data.indexedsplits.IndexedSplits;
import adams.data.indexedsplits.IndexedSplitsRun;
import adams.data.indexedsplits.IndexedSplitsRuns;
import adams.data.indexedsplits.SplitIndices;
import adams.flow.container.WekaEvaluationContainer;
import adams.flow.core.Actor;
import adams.flow.core.CallableActorHelper;
import adams.flow.core.CallableActorReference;
import adams.flow.source.WekaClassifierSetup;
import adams.flow.transformer.indexedsplitsrunsevaluation.AbstractIndexedSplitsRunsEvaluation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.core.Instance;
import weka.core.Instances;

public class InstancesIndexedSplitsRunsEvaluation
extends AbstractIndexedSplitsRunsEvaluation<Instances, WekaEvaluationContainer[]> {
    private static final long serialVersionUID = 2181874663254037648L;
    protected String m_TrainSplitName;
    protected String m_TestSplitName;
    protected CallableActorReference m_Classifier;
    protected boolean m_DiscardPredictions;
    protected Classifier m_ManualClassifier;

    public String globalInfo() {
        return "Evaluates the specified classifier on the indexed splits runs applied to the incoming data.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("train-split-name", "trainSplitName", (Object)"train");
        this.m_OptionManager.add("test-split-name", "testSplitName", (Object)"test");
        this.m_OptionManager.add("classifier", "classifier", (Object)new CallableActorReference(WekaClassifierSetup.class.getSimpleName()));
        this.m_OptionManager.add("no-predictions", "discardPredictions", (Object)false);
    }

    public void setTrainSplitName(String value) {
        this.m_TrainSplitName = value;
        this.reset();
    }

    public String getTrainSplitName() {
        return this.m_TrainSplitName;
    }

    public String trainSplitNameTipText() {
        return "The name of the split to use for training.";
    }

    public void setTestSplitName(String value) {
        this.m_TestSplitName = value;
        this.reset();
    }

    public String getTestSplitName() {
        return this.m_TestSplitName;
    }

    public String testSplitNameTipText() {
        return "The name of the split to use for testing.";
    }

    public void setClassifier(CallableActorReference value) {
        this.m_Classifier = value;
        this.reset();
    }

    public CallableActorReference getClassifier() {
        return this.m_Classifier;
    }

    public String classifierTipText() {
        return "The classifier to evaluate on the splits.";
    }

    public void setDiscardPredictions(boolean value) {
        this.m_DiscardPredictions = value;
        this.reset();
    }

    public boolean getDiscardPredictions() {
        return this.m_DiscardPredictions;
    }

    public String discardPredictionsTipText() {
        return "If enabled, the collection of predictions during evaluation is suppressed, wich will conserve memory.";
    }

    public void setManualClassifier(Classifier value) {
        this.m_ManualClassifier = value;
    }

    public Classifier getManualClassifier() {
        return this.m_ManualClassifier;
    }

    public Class accepts() {
        return Instances.class;
    }

    public Class generates() {
        return WekaEvaluationContainer[].class;
    }

    public boolean requiresFlowContext() {
        return this.m_ManualClassifier == null;
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"trainSplitName", (Object)this.m_TrainSplitName, (String)"train: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"testSplitName", (Object)this.m_TestSplitName, (String)", test: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"classifier", (Object)this.m_Classifier, (String)", classifier: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"discardPredictions", (boolean)this.m_DiscardPredictions, (String)"discarding predictions", (String)",");
        return result;
    }

    protected Classifier getClassifierInstance(MessageCollection errors) {
        if (this.m_ManualClassifier != null) {
            return this.m_ManualClassifier;
        }
        Classifier result = (Classifier)CallableActorHelper.getSetup(Classifier.class, (CallableActorReference)this.m_Classifier, (Actor)this.m_FlowContext, (MessageCollection)errors);
        if (result == null && !errors.isEmpty()) {
            this.getLogger().severe(errors.toString());
        }
        return result;
    }

    protected Map<String, Instances> applyIndexedSplit(IndexedSplit indexedSplit, Instances data) {
        HashMap<String, Instances> result = new HashMap<String, Instances>();
        for (String key : indexedSplit.getIndices().keySet()) {
            SplitIndices splitIndices = (SplitIndices)indexedSplit.getIndices().get(key);
            int[] indices = splitIndices.getIndices();
            Instances split = new Instances(data, indices.length);
            for (int i = 0; i < indices.length; ++i) {
                Instance inst = (Instance)data.instance(indices[i]).copy();
                split.add(inst);
            }
            result.put(key, split);
        }
        return result;
    }

    protected WekaEvaluationContainer[] doEvaluate(Instances data, IndexedSplitsRuns runs, MessageCollection errors) {
        ArrayList<WekaEvaluationContainer> result = new ArrayList<WekaEvaluationContainer>();
        Classifier template = this.getClassifierInstance(errors);
        if (template == null) {
            return null;
        }
        try {
            for (int run = 0; run < runs.size(); ++run) {
                if (this.m_Stopped) {
                    return null;
                }
                IndexedSplitsRun indexedSplitsRun = (IndexedSplitsRun)runs.get(run);
                IndexedSplits indexedSplits = indexedSplitsRun.getSplits();
                Evaluation evaluation = new Evaluation(data);
                Instances testFull = new Instances(data, 0);
                for (int split = 0; split < indexedSplits.size(); ++split) {
                    if (this.m_Stopped) {
                        return null;
                    }
                    Map<String, Instances> namedSplits = this.applyIndexedSplit((IndexedSplit)indexedSplits.get(split), data);
                    if (!namedSplits.containsKey(this.m_TrainSplitName)) {
                        throw new IllegalArgumentException("Failed to locate train split '" + this.m_TrainSplitName + "' (run=" + run + ", split=" + split + "), available: " + Utils.flatten((Object[])namedSplits.keySet().toArray(), (String)","));
                    }
                    if (!namedSplits.containsKey(this.m_TestSplitName)) {
                        throw new IllegalArgumentException("Failed to locate test split '" + this.m_TestSplitName + "' (run=" + run + ", split=" + split + "), available: " + Utils.flatten((Object[])namedSplits.keySet().toArray(), (String)","));
                    }
                    Instances train = namedSplits.get(this.m_TrainSplitName);
                    Instances test = namedSplits.get(this.m_TestSplitName);
                    Classifier classifier = (Classifier)ObjectCopyHelper.copyObject((Object)template);
                    classifier.buildClassifier(train);
                    evaluation.evaluateModel(classifier, test, new Object[0]);
                    testFull.addAll((Collection)test);
                }
                WekaEvaluationContainer cont = new WekaEvaluationContainer(evaluation);
                cont.setValue("Test data", testFull);
                result.add(cont);
            }
        }
        catch (Exception e) {
            errors.add("Failed to evaluate!", (Throwable)e);
        }
        if (errors.isEmpty()) {
            return result.toArray(new WekaEvaluationContainer[0]);
        }
        return null;
    }
}

