/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.wekaclassifiersetupprocessor;

import adams.core.ObjectCopyHelper;
import adams.core.Utils;
import adams.flow.transformer.wekaclassifiersetupprocessor.AbstractClassifierSetupProcessor;
import java.util.ArrayList;
import weka.classifiers.Classifier;
import weka.classifiers.meta.Vote;
import weka.core.SelectedTag;

public class VotedPairs
extends AbstractClassifierSetupProcessor {
    private static final long serialVersionUID = -2999477464567917216L;
    protected VotingType m_VotingType;

    public String globalInfo() {
        return "Generates an array of classifiers that contains the original ones, but also all possible classifier pairs encapsulated in the " + Utils.classToString(Vote.class) + " meta-classifier.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("voting-type", "votingType", (Object)VotingType.AVERAGE_RULE);
    }

    public void setVotingType(VotingType value) {
        this.m_VotingType = value;
        this.reset();
    }

    public VotingType getVotingType() {
        return this.m_VotingType;
    }

    public String votingTypeTipText() {
        return "The type of voting to use.";
    }

    @Override
    protected Classifier[] doProcess(Classifier[] classifiers) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Classifier cls : classifiers) {
            result.add((Classifier)ObjectCopyHelper.copyObject((Object)cls));
        }
        for (int i = 0; i < classifiers.length - 1; ++i) {
            for (int n = i + 1; n < classifiers.length; ++n) {
                Vote vote = new Vote();
                vote.setClassifiers(new Classifier[]{(Classifier)ObjectCopyHelper.copyObject((Object)classifiers[i]), (Classifier)ObjectCopyHelper.copyObject((Object)classifiers[n])});
                vote.setCombinationRule(this.m_VotingType.getSelectedTag());
                result.add(vote);
            }
        }
        return result.toArray(new Classifier[0]);
    }

    public static enum VotingType {
        AVERAGE_RULE(1),
        PRODUCT_RULE(2),
        MAJORITY_VOTING_RULE(3),
        MIN_RULE(4),
        MAX_RULE(5),
        MEDIAN_RULE(6);

        private int m_Type;

        private VotingType(int type) {
            this.m_Type = type;
        }

        public int getType() {
            return this.m_Type;
        }

        public SelectedTag getSelectedTag() {
            return new SelectedTag(this.m_Type, Vote.TAGS_RULES);
        }
    }
}

