/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.wekaclusterer;

import adams.core.TechnicalInformation;
import adams.core.TechnicalInformationHandler;
import adams.flow.container.WekaModelContainer;
import adams.flow.transformer.wekaclusterer.AbstractClustererPostProcessor;
import java.util.Arrays;
import java.util.logging.Level;
import weka.clusterers.Clusterer;
import weka.core.DistanceFunction;
import weka.core.EuclideanDistance;
import weka.core.Instances;

public class AverageSilhouetteCoefficient
extends AbstractClustererPostProcessor
implements TechnicalInformationHandler {
    private static final long serialVersionUID = 1326504894062853934L;
    public static final String VALUE_AVERAGE_SILHOUETTE_COEFFICIENT = "Average Silhouette Coefficient";
    protected DistanceFunction m_DistanceFunction;

    public String globalInfo() {
        return "Computes the average Silhouette coefficient for the clusters.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.MISC);
        result.setValue(TechnicalInformation.Field.AUTHOR, "WikiPedia");
        result.setValue(TechnicalInformation.Field.TITLE, "Silhouette (clustering)");
        result.setValue(TechnicalInformation.Field.URL, "https://en.wikipedia.org/wiki/Silhouette_%28clustering%29");
        return result;
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("distance-function", "distanceFunction", (Object)new EuclideanDistance());
    }

    public void setDistanceFunction(DistanceFunction value) {
        this.m_DistanceFunction = value;
        this.reset();
    }

    public DistanceFunction getDistanceFunction() {
        return this.m_DistanceFunction;
    }

    public String distanceFunctionTipText() {
        return "The distance function to use.";
    }

    @Override
    protected String[] getContainerKeys() {
        return new String[]{VALUE_AVERAGE_SILHOUETTE_COEFFICIENT};
    }

    @Override
    protected WekaModelContainer doPostProcess(WekaModelContainer cont) {
        Clusterer clusterer = (Clusterer)cont.getValue("Model");
        Instances data = (Instances)cont.getValue("Dataset");
        try {
            int i;
            this.m_DistanceFunction.setInstances(data);
            int[] clusterIndexOfInstance = new int[data.numInstances()];
            for (i = 0; i < data.numInstances(); ++i) {
                clusterIndexOfInstance[i] = clusterer.clusterInstance(data.instance(i));
            }
            double sumSilhouetteCoefficients = 0.0;
            for (i = 0; i < data.numInstances(); ++i) {
                double[] averageDistancePerCluster = new double[clusterer.numberOfClusters()];
                int[] numberOfInstancesPerCluster = new int[clusterer.numberOfClusters()];
                for (int j = 0; j < data.numInstances(); ++j) {
                    int n = clusterIndexOfInstance[j];
                    averageDistancePerCluster[n] = averageDistancePerCluster[n] + this.m_DistanceFunction.distance(data.instance(i), data.instance(j));
                    int n2 = clusterIndexOfInstance[j];
                    numberOfInstancesPerCluster[n2] = numberOfInstancesPerCluster[n2] + 1;
                }
                for (int k = 0; k < averageDistancePerCluster.length; ++k) {
                    int n = k;
                    averageDistancePerCluster[n] = averageDistancePerCluster[n] / (double)numberOfInstancesPerCluster[k];
                }
                double avgDistance = averageDistancePerCluster[clusterIndexOfInstance[i]];
                averageDistancePerCluster[clusterIndexOfInstance[i]] = Double.MAX_VALUE;
                double closestDistance = Arrays.stream(averageDistancePerCluster).min().getAsDouble();
                sumSilhouetteCoefficients += clusterer.numberOfClusters() > 1 ? (closestDistance - avgDistance) / Math.max(avgDistance, closestDistance) : 0.0;
            }
            double average = sumSilhouetteCoefficients / (double)data.numInstances();
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Average silhouette coefficient: " + average);
            }
            cont.addAdditionalName(VALUE_AVERAGE_SILHOUETTE_COEFFICIENT);
            cont.setValue(VALUE_AVERAGE_SILHOUETTE_COEFFICIENT, average);
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to compute average silhouette coefficient!", (Throwable)e);
        }
        return cont;
    }
}

