/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.wekaclusterer;

import adams.flow.transformer.wekaclusterer.AbstractClusterMembershipPostProcessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.logging.Level;
import weka.clusterers.Clusterer;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;

public class ClusterCounts
extends AbstractClusterMembershipPostProcessor {
    private static final long serialVersionUID = 5983792992620091051L;

    public String globalInfo() {
        return "Creates an overview of how many instances get clustered into each cluster.\nStored in container under: Clustered dataset";
    }

    protected Instances createOutputFormat(Instances data) {
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        atts.add(new Attribute("Cluster"));
        atts.add(new Attribute("Count"));
        Instances result = new Instances(data.relationName(), atts, 0);
        return result;
    }

    @Override
    protected Instances processDatasetWithClusterer(Instances data, Clusterer clusterer) {
        int cluster;
        int i;
        Instances result = this.createOutputFormat(data);
        HashMap<Integer, Integer> counts = new HashMap<Integer, Integer>();
        for (i = 0; i < data.numInstances(); ++i) {
            try {
                cluster = clusterer.clusterInstance(data.instance(i));
                if (!counts.containsKey(cluster)) {
                    counts.put(cluster, 0);
                }
                counts.put(cluster, (Integer)counts.get(cluster) + 1);
                continue;
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Failed to cluster instance #" + (i + 1) + "!", (Throwable)e);
            }
        }
        ArrayList clusters = new ArrayList(counts.keySet());
        Collections.sort(clusters);
        for (i = 0; i < clusters.size(); ++i) {
            cluster = (Integer)clusters.get(i);
            DenseInstance inst = new DenseInstance(1.0, new double[]{cluster, ((Integer)counts.get(cluster)).intValue()});
            result.add((Instance)inst);
        }
        return result;
    }
}

