/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.wekadatasetsmerge;

import adams.core.QuickInfoSupporter;
import adams.core.Utils;
import adams.core.base.BaseRegExp;
import adams.core.base.BaseString;
import adams.core.option.AbstractOptionHandler;
import adams.data.weka.columnfinder.Class;
import adams.data.weka.columnfinder.ColumnFinder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;

public abstract class AbstractMerge
extends AbstractOptionHandler
implements QuickInfoSupporter {
    private static final long serialVersionUID = 87541569847452058L;
    protected static final String DATASET_KEYWORD = "{DATASET}";
    protected static final int ROW_MISSING = -1;
    protected ColumnFinder m_ClassFinder;
    protected BaseString[] m_DatasetNames;
    protected BaseRegExp[] m_AttributeRenameFindRegexs;
    protected BaseString[] m_AttributeRenameFormatStrings;
    protected String m_MergedDatasetName;
    protected boolean m_EnsureEqualValues;
    protected Instances[] m_Datasets;
    protected int[][] m_ClassAttributes;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("class-finder", "classFinder", (Object)new Class());
        this.m_OptionManager.add("dataset-names", "datasetNames", (Object)new BaseString[0]);
        this.m_OptionManager.add("attr-renames-exp", "attributeRenamesExp", (Object)new BaseRegExp[0]);
        this.m_OptionManager.add("attr-renames-format", "attributeRenamesFormat", (Object)new BaseString[0]);
        this.m_OptionManager.add("output-name", "outputName", (Object)"output");
        this.m_OptionManager.add("ensure-equal-values", "ensureEqualValues", (Object)false);
    }

    public ColumnFinder getClassFinder() {
        return this.m_ClassFinder;
    }

    public void setClassFinder(ColumnFinder value) {
        this.m_ClassFinder = value;
        this.reset();
    }

    public String classFinderTipText() {
        return "The column finder to use to find class attributes in the datasets.";
    }

    public BaseString[] getDatasetNames() {
        return this.m_DatasetNames;
    }

    public void setDatasetNames(BaseString[] value) {
        if (value == null) {
            value = new BaseString[]{};
        }
        if (this.m_AttributeRenameFindRegexs != null && value.length < this.m_AttributeRenameFindRegexs.length) {
            BaseString[] expandedValue = new BaseString[this.m_AttributeRenameFindRegexs.length];
            for (int i = 0; i < this.m_AttributeRenameFindRegexs.length; ++i) {
                expandedValue[i] = i < value.length ? value[i] : new BaseString("Dataset" + i);
            }
            value = expandedValue;
        }
        this.m_DatasetNames = value;
        this.reset();
    }

    public String datasetNamesTipText() {
        return "The list of dataset names to use in attribute renaming.";
    }

    public BaseRegExp[] getAttributeRenamesExp() {
        return this.m_AttributeRenameFindRegexs;
    }

    public void setAttributeRenamesExp(BaseRegExp[] value) {
        this.m_AttributeRenameFindRegexs = value;
        this.setAttributeRenamesFormat(this.m_AttributeRenameFormatStrings);
        this.setDatasetNames(this.m_DatasetNames);
        this.reset();
    }

    public String attributeRenamesExpTipText() {
        return "The expressions to use to select attribute names for renaming (one per dataset).";
    }

    public BaseString[] getAttributeRenamesFormat() {
        return this.m_AttributeRenameFormatStrings;
    }

    public void setAttributeRenamesFormat(BaseString[] value) {
        if (value == null) {
            value = new BaseString[]{};
        }
        if (this.m_AttributeRenameFindRegexs != null && value.length < this.m_AttributeRenameFindRegexs.length) {
            value = (BaseString[])Utils.adjustArray((Object)value, (int)this.m_AttributeRenameFindRegexs.length, (Object)new BaseString("$0"));
        }
        this.m_AttributeRenameFormatStrings = value;
        this.reset();
    }

    public String attributeRenamesFormatTipText() {
        return "One format string for each renaming expression to specify how to rename the attribute. Can contain the {DATASET} keyword which will be replaced by the dataset name, and also group identifiers which will be replaced by groups from the renaming regex.";
    }

    public String getOutputName() {
        return this.m_MergedDatasetName;
    }

    public void setOutputName(String value) {
        this.m_MergedDatasetName = value;
        this.reset();
    }

    public String outputNameTipText() {
        return "The name to use for the merged dataset.";
    }

    public boolean getEnsureEqualValues() {
        return this.m_EnsureEqualValues;
    }

    public void setEnsureEqualValues(boolean value) {
        this.m_EnsureEqualValues = value;
        this.reset();
    }

    public String ensureEqualValuesTipText() {
        return "Whether multiple attributes being merged into a single attribute require equal values from all sources.";
    }

    public String getQuickInfo() {
        return null;
    }

    protected void setValue(Instance toSet, int attributeIndex, Object value) {
        if (toSet == null) {
            return;
        }
        Attribute attribute = toSet.attribute(attributeIndex);
        if (attribute.isString()) {
            toSet.setValue(attributeIndex, (String)value);
        } else if (attribute.isRelationValued()) {
            int relationIndex = attribute.addRelation((Instances)value);
            toSet.setValue(attributeIndex, (double)relationIndex);
        } else {
            toSet.setValue(attributeIndex, ((Double)value).doubleValue());
        }
    }

    protected Object getValue(Instance toGetFrom, int attributeIndex) {
        if (toGetFrom == null) {
            return null;
        }
        Attribute attribute = toGetFrom.attribute(attributeIndex);
        if (attribute.isString()) {
            return toGetFrom.stringValue(attributeIndex);
        }
        if (attribute.isRelationValued()) {
            return toGetFrom.relationalValue(attributeIndex);
        }
        return toGetFrom.value(attributeIndex);
    }

    protected Instance newInstanceForDataset(Instances dataset) {
        DenseInstance instance = new DenseInstance(dataset.numAttributes());
        instance.setDataset(dataset);
        return instance;
    }

    protected String check(Instances[] datasets) {
        if (datasets == null) {
            return "No datasets to merge!";
        }
        if (datasets.length < 2) {
            return "Require at least 2 datasets to merge, but " + datasets.length + " were provided.";
        }
        if (this.m_MergedDatasetName.length() == 0) {
            return "Must provide a name for the output dataset.";
        }
        if (this.m_DatasetNames.length < this.m_AttributeRenameFindRegexs.length) {
            return "Not enough dataset names supplied for attribute renaming (require " + this.m_AttributeRenameFindRegexs.length + ", have " + this.m_DatasetNames.length + ").";
        }
        if (this.m_AttributeRenameFormatStrings.length < this.m_AttributeRenameFindRegexs.length) {
            return "Not enough format strings supplied for attribute renaming (require " + this.m_AttributeRenameFindRegexs.length + ", have " + this.m_AttributeRenameFormatStrings.length + ").";
        }
        return null;
    }

    protected String checkAttributeMapping(Map<String, List<SourceAttribute>> attributeMapping) {
        for (String mappedName : attributeMapping.keySet()) {
            List<SourceAttribute> sources = attributeMapping.get(mappedName);
            int referenceType = sources.get(0).getSource().type();
            for (SourceAttribute source : sources) {
                if (source.getSource().type() == referenceType) continue;
                return "Source data mismatch for mapped attribute " + mappedName + "! " + this.m_DatasetNames[sources.get((int)0).datasetIndex] + ":" + sources.get((int)0).attributeName + " = " + Attribute.typeToString((int)referenceType) + ", " + this.m_DatasetNames[source.datasetIndex] + ":" + source.attributeName + " = " + Attribute.typeToString((int)source.getSource().type());
            }
        }
        return null;
    }

    public Instances merge(Instances[] datasets) {
        this.resetInternalState(datasets);
        String msg = this.check(datasets);
        if (msg != null) {
            throw new IllegalStateException(msg);
        }
        Map<String, List<SourceAttribute>> attributeMapping = this.createAttributeMapping();
        msg = this.checkAttributeMapping(attributeMapping);
        if (msg != null) {
            throw new IllegalStateException(msg);
        }
        Instances mergedDataset = this.createEmptyResultantDataset(attributeMapping);
        Enumeration<int[]> rowSetEnumeration = this.getRowSetEnumeration();
        while (rowSetEnumeration.hasMoreElements()) {
            int[] rowSet = rowSetEnumeration.nextElement();
            Instance mergedInstance = this.newInstanceForDataset(mergedDataset);
            for (int attributeIndex = 0; attributeIndex < mergedDataset.numAttributes(); ++attributeIndex) {
                Object value;
                Attribute mergedAttribute = mergedDataset.attribute(attributeIndex);
                List<SourceAttribute> sourceAttributes = attributeMapping.get(mergedAttribute.name());
                Object object = value = this.m_EnsureEqualValues ? this.getValueEnsureEqual(rowSet, sourceAttributes) : this.getValueFirstAvailable(rowSet, sourceAttributes);
                if (value == null) continue;
                this.setValue(mergedInstance, attributeIndex, value);
            }
            mergedDataset.add(mergedInstance);
        }
        return mergedDataset;
    }

    protected Object getValueFirstAvailable(int[] rowSet, List<SourceAttribute> sourceAttributes) {
        for (SourceAttribute source : sourceAttributes) {
            Instance instance;
            int rowIndex = rowSet[source.datasetIndex];
            if (rowIndex == -1 || (instance = this.m_Datasets[source.datasetIndex].instance(rowIndex)).isMissing(source.attributeIndex)) continue;
            return this.getValue(instance, source.attributeIndex);
        }
        return null;
    }

    protected Object getValueEnsureEqual(int[] rowSet, List<SourceAttribute> sourceAttributeElements) {
        Object value = null;
        SourceAttribute valueElement = null;
        int valueRowIndex = -1;
        for (SourceAttribute element : sourceAttributeElements) {
            Instance instance;
            int rowIndex = rowSet[element.datasetIndex];
            if (rowIndex == -1 || (instance = this.m_Datasets[element.datasetIndex].instance(rowIndex)).isMissing(element.attributeIndex)) continue;
            Object currentValue = this.getValue(instance, element.attributeIndex);
            if (value == null) {
                value = currentValue;
                valueElement = element;
                valueRowIndex = rowIndex;
                continue;
            }
            if (value.equals(currentValue)) continue;
            throw new IllegalStateException("Merging attributes have multiple different source values! (" + currentValue + " in " + this.m_DatasetNames[element.datasetIndex] + ", attribute " + element.attributeName + ", row " + rowIndex + " instead of " + value + " in " + this.m_DatasetNames[valueElement.datasetIndex] + ", attribute " + valueElement.attributeName + ", row " + valueRowIndex + ")");
        }
        return value;
    }

    protected Map<String, List<SourceAttribute>> createAttributeMapping() {
        HashMap<String, List<SourceAttribute>> mapping = new HashMap<String, List<SourceAttribute>>();
        for (int datasetIndex = 0; datasetIndex < this.m_Datasets.length; ++datasetIndex) {
            Instances dataset = this.m_Datasets[datasetIndex];
            for (int attributeIndex = 0; attributeIndex < dataset.numAttributes(); ++attributeIndex) {
                String attributeName = dataset.attribute(attributeIndex).name();
                SourceAttribute source = new SourceAttribute(datasetIndex, attributeIndex, attributeName);
                String mappedAttributeName = this.getMappedAttributeName(source);
                if (!mapping.containsKey(mappedAttributeName)) {
                    mapping.put(mappedAttributeName, new LinkedList());
                }
                ((List)mapping.get(mappedAttributeName)).add(source);
            }
        }
        return mapping;
    }

    protected boolean isAnyClassAttribute(List<SourceAttribute> sources) {
        for (SourceAttribute source : sources) {
            if (!this.isClassAttribute(source)) continue;
            return true;
        }
        return false;
    }

    protected boolean isClassAttribute(SourceAttribute source) {
        return this.isClassAttribute(source.datasetIndex, source.attributeIndex);
    }

    protected boolean isClassAttribute(int datasetIndex, int attributeIndex) {
        if (this.m_ClassAttributes == null) {
            this.recordClassAttributes();
        }
        return Arrays.binarySearch(this.m_ClassAttributes[datasetIndex], attributeIndex) >= 0;
    }

    protected void recordClassAttributes() {
        this.m_ClassAttributes = new int[this.m_Datasets.length][];
        for (int i = 0; i < this.m_Datasets.length; ++i) {
            Instances dataset = this.m_Datasets[i];
            int[] classAttributes = this.m_ClassFinder.findColumns(dataset);
            Arrays.sort(classAttributes);
            this.m_ClassAttributes[i] = classAttributes;
        }
    }

    protected Instances createEmptyResultantDataset(Map<String, List<SourceAttribute>> attributeMapping) {
        LinkedList<List<SourceAttribute>> orderingList = new LinkedList<List<SourceAttribute>>();
        HashMap<List<SourceAttribute>, Attribute> attributes = new HashMap<List<SourceAttribute>, Attribute>();
        for (String mappedAttributeName : attributeMapping.keySet()) {
            List<SourceAttribute> list = attributeMapping.get(mappedAttributeName);
            Attribute mappedAttribute = this.createMappedAttribute(mappedAttributeName, list);
            attributes.put(list, mappedAttribute);
            orderingList.add(list);
        }
        orderingList.sort(this::compare);
        ArrayList<Attribute> orderedAttributes = new ArrayList<Attribute>(orderingList.size());
        for (List list : orderingList) {
            orderedAttributes.add((Attribute)attributes.get(list));
        }
        return new Instances(this.m_MergedDatasetName, orderedAttributes, 0);
    }

    protected Attribute createMappedAttribute(String name, List<SourceAttribute> sources) {
        return sources.get(0).getSource().copy(name);
    }

    protected int compare(List<SourceAttribute> sources1, List<SourceAttribute> sources2) {
        boolean className1 = this.isAnyClassAttribute(sources1);
        boolean className2 = this.isAnyClassAttribute(sources2);
        if (className1 && !className2) {
            return 1;
        }
        if (!className1 && className2) {
            return -1;
        }
        return sources1.get(0).compareTo(sources2.get(0));
    }

    protected String getMappedAttributeName(SourceAttribute source) {
        BaseRegExp renameRegex;
        Matcher attributeNameMatcher;
        if (this.isClassAttribute(source)) {
            return source.attributeName;
        }
        if (source.datasetIndex < this.m_AttributeRenameFindRegexs.length && (attributeNameMatcher = (renameRegex = this.m_AttributeRenameFindRegexs[source.datasetIndex]).patternValue().matcher(source.attributeName)).matches()) {
            String mappedString = this.m_AttributeRenameFormatStrings[source.datasetIndex].stringValue();
            mappedString = mappedString.replace(DATASET_KEYWORD, this.m_DatasetNames[source.datasetIndex].stringValue());
            for (int groupIndex = attributeNameMatcher.groupCount(); groupIndex >= 0; --groupIndex) {
                String groupMatch = attributeNameMatcher.group(groupIndex);
                mappedString = mappedString.replace("$" + groupIndex, groupMatch);
            }
            return mappedString;
        }
        return source.attributeName;
    }

    protected void resetInternalState(Instances[] datasets) {
        this.m_Datasets = datasets;
        this.m_ClassAttributes = null;
    }

    protected abstract Enumeration<int[]> getRowSetEnumeration();

    protected class SourceAttribute
    implements Comparable<SourceAttribute> {
        public final int datasetIndex;
        public final int attributeIndex;
        public final String attributeName;

        public SourceAttribute(int datasetIndex, int attributeIndex, String attributeName) {
            this.datasetIndex = datasetIndex;
            this.attributeIndex = attributeIndex;
            this.attributeName = attributeName;
        }

        public Attribute getSource() {
            return AbstractMerge.this.m_Datasets[this.datasetIndex].attribute(this.attributeIndex);
        }

        public String toString() {
            return this.attributeName + "[" + this.datasetIndex + ", " + this.attributeIndex + "]";
        }

        @Override
        public int compareTo(SourceAttribute o) {
            if (this.datasetIndex < o.datasetIndex) {
                return -1;
            }
            if (this.datasetIndex > o.datasetIndex) {
                return 1;
            }
            return Integer.compare(this.attributeIndex, o.attributeIndex);
        }
    }
}

