/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.wekaevaluationpostprocessor;

import adams.flow.transformer.wekaevaluationpostprocessor.AbstractWekaEvaluationPostProcessor;
import java.util.ArrayList;
import java.util.List;
import weka.classifiers.Evaluation;

public class MultiPostProcessor
extends AbstractWekaEvaluationPostProcessor {
    private static final long serialVersionUID = 7981725475588023689L;
    protected AbstractWekaEvaluationPostProcessor[] m_PostProcessors;

    public String globalInfo() {
        return "Applies the specified post-processors sequentially to the input data and combines their output.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("post-processor", "postProcessors", (Object)new AbstractWekaEvaluationPostProcessor[0]);
    }

    public void setPostProcessors(AbstractWekaEvaluationPostProcessor[] value) {
        this.m_PostProcessors = value;
        this.reset();
    }

    public AbstractWekaEvaluationPostProcessor[] getPostProcessors() {
        return this.m_PostProcessors;
    }

    public String postProcessorsTipText() {
        return "The post-processors to apply to the input data.";
    }

    @Override
    protected List<Evaluation> doPostProcess(Evaluation eval) {
        ArrayList<Evaluation> result = new ArrayList<Evaluation>();
        for (int i = 0; i < this.m_PostProcessors.length; ++i) {
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Applying post-processor #" + (i + 1));
            }
            result.addAll(this.m_PostProcessors[i].postProcess(eval));
        }
        return result;
    }
}

