/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.wekaevaluationpostprocessor;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseInterval;
import adams.core.option.OptionHandler;
import adams.flow.transformer.wekaevaluationpostprocessor.AbstractNumericClassPostProcessor;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.List;
import weka.classifiers.Evaluation;
import weka.classifiers.evaluation.Prediction;

public class SimpleSubRange
extends AbstractNumericClassPostProcessor {
    private static final long serialVersionUID = -1598212513856588223L;
    public static final String NAN = "NaN";
    protected double m_Minimum;
    protected boolean m_MinimumIncluded;
    protected double m_Maximum;
    protected boolean m_MaximumIncluded;

    public String globalInfo() {
        return "Generates an Evaluation object based on the actual class values that fall within the specified interval ranges.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("minimum", "minimum", (Object)Double.NaN);
        this.m_OptionManager.add("minimum-included", "minimumIncluded", (Object)false);
        this.m_OptionManager.add("maximum", "maximum", (Object)Double.NaN);
        this.m_OptionManager.add("maximum-included", "maximumIncluded", (Object)false);
    }

    public void setMinimum(double value) {
        this.m_Minimum = value;
        this.reset();
    }

    public double getMinimum() {
        return this.m_Minimum;
    }

    public String minimumTipText() {
        return "The minimum value that the values must satisfy; use NaN (not a number) to ignore minimum.";
    }

    public void setMinimumIncluded(boolean value) {
        this.m_MinimumIncluded = value;
        this.reset();
    }

    public boolean getMinimumIncluded() {
        return this.m_MinimumIncluded;
    }

    public String minimumIncludedTipText() {
        return "If enabled, then the minimum value gets included (testing '<=' rather than '<').";
    }

    public void setMaximum(double value) {
        this.m_Maximum = value;
        this.reset();
    }

    public double getMaximum() {
        return this.m_Maximum;
    }

    public String maximumTipText() {
        return "The maximum value that the values must satisfy; use NaN (not a number) to ignore maximum.";
    }

    public void setMaximumIncluded(boolean value) {
        this.m_MaximumIncluded = value;
        this.reset();
    }

    public boolean getMaximumIncluded() {
        return this.m_MaximumIncluded;
    }

    public String maximumIncludedTipText() {
        return "If enabled, then the maximum value gets included (testing '>=' rather than '>').";
    }

    @Override
    public String getQuickInfo() {
        Object result = this.m_MinimumIncluded ? "[" : "(";
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"minimum", (Object)this.m_Minimum);
        result = (String)result + ";";
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"maximum", (Object)this.m_Maximum);
        result = (String)result + (this.m_MaximumIncluded ? "]" : ")");
        return result;
    }

    @Override
    protected List<Evaluation> doPostProcess(Evaluation eval) {
        ArrayList<Evaluation> result = new ArrayList<Evaluation>();
        TIntArrayList indices = new TIntArrayList();
        for (int i = 0; i < eval.predictions().size(); ++i) {
            Prediction pred = (Prediction)eval.predictions().get(i);
            double value = pred.actual();
            boolean add = true;
            if (!Double.isNaN(this.m_Minimum)) {
                if (this.m_MinimumIncluded) {
                    if (value < this.m_Minimum) {
                        add = false;
                    }
                } else if (value <= this.m_Minimum) {
                    add = false;
                }
            }
            if (!Double.isNaN(this.m_Maximum)) {
                if (this.m_MaximumIncluded) {
                    if (value > this.m_Maximum) {
                        add = false;
                    }
                } else if (value >= this.m_Maximum) {
                    add = false;
                }
            }
            if (!add) continue;
            indices.add(i);
        }
        BaseInterval interval = new BaseInterval(this.m_Minimum, this.m_MinimumIncluded, this.m_Maximum, this.m_MaximumIncluded);
        result.add(this.newEvaluation("-" + interval, eval, (TIntList)indices));
        return result;
    }
}

