/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.help;

import adams.gui.core.ConsolePanel;
import adams.gui.help.AbstractHelpGenerator;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.logging.Level;
import nz.ac.waikato.cms.locator.ClassLocator;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.MultiInstanceCapabilitiesHandler;
import weka.core.OptionHandler;
import weka.core.OptionMetadata;

public class WekaOptionHandlerHelpGenerator
extends AbstractHelpGenerator {
    public boolean handles(Class cls) {
        return ClassLocator.hasInterface(OptionHandler.class, (Class)cls);
    }

    public boolean isHtml(Class cls) {
        return true;
    }

    protected String listCapabilities(Capabilities c) {
        Object result = "";
        Iterator iter = c.capabilities();
        while (iter.hasNext()) {
            if (((String)result).length() != 0) {
                result = (String)result + ", ";
            }
            result = (String)result + iter.next().toString();
        }
        return result;
    }

    protected String addCapabilities(String title, Capabilities c) {
        String result = title + "<br>";
        String caps = this.listCapabilities(c.getClassCapabilities());
        if (caps.length() != 0) {
            result = result + "<i>Class</i> - ";
            result = result + caps;
            result = result + "<br><br>";
        }
        if ((caps = this.listCapabilities(c.getAttributeCapabilities())).length() != 0) {
            result = result + "<i>Attributes</i> - ";
            result = result + caps;
            result = result + "<br><br>";
        }
        if ((caps = this.listCapabilities(c.getOtherCapabilities())).length() != 0) {
            result = result + "<i>Other</i> - ";
            result = result + caps;
            result = result + "<br><br>";
        }
        result = result + "<i>Additional</i><br>";
        result = result + "min # of instances: " + c.getMinimumNumberInstances() + "<br>";
        result = result + "<br>";
        return result;
    }

    public String generate(Class cls) {
        Object obj;
        try {
            obj = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            ConsolePanel.getSingleton().append((Object)Level.SEVERE, ((Object)((Object)this)).getClass().getName() + ": Failed to instantiate class: " + cls.getName(), (Throwable)ex);
            return null;
        }
        return this.generate(obj);
    }

    public String generate(Object obj) {
        MethodDescriptor[] methods;
        StringBuilder result = null;
        Class<?> cls = obj.getClass();
        try {
            BeanInfo bi = Introspector.getBeanInfo(cls);
            methods = bi.getMethodDescriptors();
        }
        catch (IntrospectionException ex) {
            ConsolePanel.getSingleton().append((Object)Level.SEVERE, ((Object)((Object)this)).getClass().getName() + ": Couldn't introspect class: " + cls.getName(), (Throwable)ex);
            return null;
        }
        Object[] args = new Object[]{};
        boolean firstTip = true;
        StringBuilder options = new StringBuilder();
        for (MethodDescriptor method : methods) {
            String name = method.getDisplayName();
            Method meth = method.getMethod();
            OptionMetadata meta = meth.getAnnotation(OptionMetadata.class);
            if ((name.endsWith("TipText") || meta != null) && (meth.getReturnType().equals(String.class) || meta != null)) {
                try {
                    String tempTip = meta != null ? meta.description() : (String)meth.invoke(obj, args);
                    String string = name = meta != null ? meta.displayName() : name;
                    if (firstTip) {
                        options.append("<b>Options</b><br>");
                        firstTip = false;
                    }
                    tempTip = tempTip.replace("<html>", "").replace("</html>", "").replace("<p>", "<br><br>");
                    options.append("<i>").append(name.replace("TipText", "")).append("</i> - ");
                    options.append(tempTip).append("<br><br>");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!name.equals("globalInfo") || !meth.getReturnType().equals(String.class)) continue;
            try {
                String globalInfo = (String)meth.invoke(obj, args);
                result = new StringBuilder("<b>Name</b><br>");
                result.append(cls.getName()).append("<br><br>");
                result.append("<b>Synopsis</b><br>").append(globalInfo).append("<br><br>");
                if (!(obj instanceof CapabilitiesHandler)) continue;
                result.append(this.addCapabilities("<b>Capabilities</b>", ((CapabilitiesHandler)obj).getCapabilities()));
                if (!(obj instanceof MultiInstanceCapabilitiesHandler)) continue;
                result.append(this.addCapabilities("<b>Multi-instance Capabilities</b>", ((MultiInstanceCapabilitiesHandler)obj).getMultiInstanceCapabilities()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (result != null) {
            result.append(options.toString());
        }
        if (result != null) {
            return result.toString();
        }
        return null;
    }
}

