/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.menu;

import adams.core.Properties;
import adams.core.VariableName;
import adams.core.base.ArrayDimensions;
import adams.core.base.BaseString;
import adams.core.base.BaseText;
import adams.core.io.PlaceholderDirectory;
import adams.core.io.PlaceholderFile;
import adams.core.logging.LoggingHelper;
import adams.core.option.AbstractArgumentOption;
import adams.core.option.OptionUtils;
import adams.core.option.UserMode;
import adams.data.conversion.Conversion;
import adams.data.conversion.SpreadSheetToWekaInstances;
import adams.data.conversion.WekaInstancesToSpreadSheet;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.io.input.SpreadSheetReader;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.DenseDataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.condition.bool.BooleanCondition;
import adams.flow.condition.bool.Expression;
import adams.flow.control.ArrayProcess;
import adams.flow.control.Flow;
import adams.flow.control.StorageName;
import adams.flow.control.SubProcess;
import adams.flow.control.Switch;
import adams.flow.control.Tee;
import adams.flow.control.Trigger;
import adams.flow.control.UpdateProperties;
import adams.flow.core.Actor;
import adams.flow.execution.FlowExecutionListener;
import adams.flow.execution.NullListener;
import adams.flow.sink.WekaFileWriter;
import adams.flow.source.CombineVariables;
import adams.flow.source.FileSupplier;
import adams.flow.source.NewArray;
import adams.flow.source.Start;
import adams.flow.source.StorageForLoop;
import adams.flow.source.StorageValue;
import adams.flow.transformer.ArrayLength;
import adams.flow.transformer.ArrayToSequence;
import adams.flow.transformer.BaseName;
import adams.flow.transformer.Convert;
import adams.flow.transformer.FileExtension;
import adams.flow.transformer.GetArrayElement;
import adams.flow.transformer.IncVariable;
import adams.flow.transformer.PrependDir;
import adams.flow.transformer.SetArrayElement;
import adams.flow.transformer.SetStorageValue;
import adams.flow.transformer.SetVariable;
import adams.flow.transformer.SpreadSheetAppend;
import adams.flow.transformer.SpreadSheetFileReader;
import adams.flow.transformer.SpreadSheetInfo;
import adams.flow.transformer.WekaFileReader;
import adams.flow.transformer.WekaFilter;
import adams.flow.transformer.WekaRenameRelation;
import adams.gui.application.AbstractApplicationFrame;
import adams.gui.application.AbstractBasicMenuItemDefinition;
import adams.gui.application.ChildFrame;
import adams.gui.chooser.AbstractChooserPanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.PropertiesParameterPanel;
import adams.gui.goe.GenericObjectEditorPanel;
import adams.gui.wizard.AbstractWizardPage;
import adams.gui.wizard.FinalPage;
import adams.gui.wizard.PageCheck;
import adams.gui.wizard.ParameterPanelPage;
import adams.gui.wizard.SelectDirectoryPage;
import adams.gui.wizard.WekaSelectMultipleDatasetsPage;
import adams.gui.wizard.WizardPane;
import adams.parser.BooleanExpressionText;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.logging.Level;
import weka.core.converters.AArffLoader;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.AbstractFileSaver;
import weka.core.converters.ArffLoader;
import weka.core.converters.ArffSaver;
import weka.filters.Filter;
import weka.filters.unsupervised.instance.RemoveRange;

public class MakeCompatibleDatasets
extends AbstractBasicMenuItemDefinition {
    private static final long serialVersionUID = 7586443345167287461L;
    public static final String CUSTOM_WEKA_FILE_LOADER = "CustomWekaFileLoader";
    public static final String WEKA_FILE_LOADER = "WekaFileLoader";
    public static final String CUSTOM_ADAMS_READER = "CustomAdamsReader";
    public static final String ADAMS_READER = "AdamsReader";
    public static final String ADAMS_FILE_EXTENSION = "AdamsFileExtension";

    public MakeCompatibleDatasets() {
        this(null);
    }

    public MakeCompatibleDatasets(AbstractApplicationFrame owner) {
        super(owner);
    }

    public String getIconName() {
        return "makecompatible.png";
    }

    public void launch() {
        final WizardPane wizard = new WizardPane();
        wizard.setCustomFinishText("Generate");
        WekaSelectMultipleDatasetsPage infiles = new WekaSelectMultipleDatasetsPage("Input");
        infiles.setDescription("Select the datasets that you want to make compatible.\nYou have to choose at least two.");
        infiles.setPageCheck(new PageCheck(){

            public boolean checkPage(AbstractWizardPage page) {
                Properties props = page.getProperties();
                try {
                    String[] files = OptionUtils.splitOptions((String)props.getProperty("files"));
                    return files.length >= 2;
                }
                catch (Exception e) {
                    MakeCompatibleDatasets.this.getLogger().log(Level.SEVERE, "Failed to obtain files:", (Throwable)e);
                    return false;
                }
            }
        });
        wizard.addPage((AbstractWizardPage)infiles);
        ParameterPanelPage format = new ParameterPanelPage("Format");
        format.setDescription("Here you can specify how to load the datasets.\nIf you need to use custom parameters for the Weka loader, then please tick the checkbox for using a custom Weka loader and configure the loader accordingly.\nThe Weka CSV loader does not handle all CSV files correctly. In that case, you can try using the ADAMS one. In that case, tick the checkbox for using a custom ADAMS reader and configure the reader accordingly. If necessary, you can also modify the file extension that the ADAMS reader reacts to.");
        format.getParameterPanel().addPropertyType(CUSTOM_WEKA_FILE_LOADER, PropertiesParameterPanel.PropertyType.BOOLEAN);
        format.getParameterPanel().setLabel(CUSTOM_WEKA_FILE_LOADER, "Use custom Weka loader");
        format.getParameterPanel().addPropertyType(WEKA_FILE_LOADER, PropertiesParameterPanel.PropertyType.OBJECT_EDITOR);
        format.getParameterPanel().setLabel(WEKA_FILE_LOADER, "Weka loader");
        format.getParameterPanel().setChooser(WEKA_FILE_LOADER, (AbstractChooserPanel)new GenericObjectEditorPanel(AbstractFileLoader.class, (Object)new ArffLoader(), true));
        format.getParameterPanel().addPropertyType(CUSTOM_ADAMS_READER, PropertiesParameterPanel.PropertyType.BOOLEAN);
        format.getParameterPanel().setLabel(CUSTOM_ADAMS_READER, "Use custom ADAMS reader");
        format.getParameterPanel().addPropertyType(ADAMS_READER, PropertiesParameterPanel.PropertyType.OBJECT_EDITOR);
        format.getParameterPanel().setLabel(ADAMS_READER, "ADAMS reader");
        format.getParameterPanel().setChooser(ADAMS_READER, (AbstractChooserPanel)new GenericObjectEditorPanel(SpreadSheetReader.class, (Object)new CsvSpreadSheetReader(), true));
        format.getParameterPanel().addPropertyType(ADAMS_FILE_EXTENSION, PropertiesParameterPanel.PropertyType.STRING);
        format.getParameterPanel().setLabel(ADAMS_FILE_EXTENSION, "File extension for ADAMS reader");
        format.getParameterPanel().setPropertyOrder(new String[]{CUSTOM_WEKA_FILE_LOADER, WEKA_FILE_LOADER, CUSTOM_ADAMS_READER, ADAMS_READER, ADAMS_FILE_EXTENSION});
        Properties props = new Properties();
        props.setBoolean(CUSTOM_WEKA_FILE_LOADER, Boolean.valueOf(false));
        props.setProperty(WEKA_FILE_LOADER, OptionUtils.getCommandLine((Object)new ArffLoader()));
        props.setBoolean(CUSTOM_ADAMS_READER, Boolean.valueOf(false));
        props.setProperty(ADAMS_READER, OptionUtils.getCommandLine((Object)new CsvSpreadSheetReader()));
        props.setProperty(ADAMS_FILE_EXTENSION, "csv");
        format.getParameterPanel().setProperties(props);
        wizard.addPage((AbstractWizardPage)format);
        SelectDirectoryPage outdir = new SelectDirectoryPage("Output");
        outdir.setDescription("Select the directory to save the generated data to (in ARFF format).");
        wizard.addPage((AbstractWizardPage)outdir);
        FinalPage finalpage = new FinalPage();
        finalpage.setLogo(null);
        finalpage.setDescription("<html><h2>Ready</h2>Please click on <b>Generate</b> to start the process.</html>");
        wizard.addPage((AbstractWizardPage)finalpage);
        final ChildFrame frame = this.createChildFrame((Component)wizard, GUIHelper.getDefaultDialogDimension());
        wizard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!e.getActionCommand().equals("Finish")) {
                    frame.dispose();
                    return;
                }
                Properties props = wizard.getProperties(false);
                MakeCompatibleDatasets.this.doGenerate(frame, props);
            }
        });
        wizard.update();
    }

    protected void doGenerate(ChildFrame frame, Properties props) {
        PlaceholderDirectory output;
        String ext;
        SpreadSheetReader reader;
        AbstractFileLoader loader;
        PlaceholderFile[] input;
        try {
            String[] files = OptionUtils.splitOptions((String)props.getProperty("files"));
            input = new PlaceholderFile[files.length];
            for (int i = 0; i < files.length; ++i) {
                input[i] = new PlaceholderFile(files[i]);
            }
            loader = null;
            if (props.getBoolean(CUSTOM_WEKA_FILE_LOADER).booleanValue()) {
                loader = (AbstractFileLoader)OptionUtils.forAnyCommandLine(AbstractFileLoader.class, (String)props.getProperty(WEKA_FILE_LOADER));
            }
            reader = null;
            if (props.getBoolean(CUSTOM_ADAMS_READER).booleanValue()) {
                reader = (SpreadSheetReader)OptionUtils.forAnyCommandLine(SpreadSheetReader.class, (String)props.getProperty(ADAMS_READER));
            }
            ext = props.getProperty(ADAMS_FILE_EXTENSION);
            output = new PlaceholderDirectory(props.getPath("directory"));
        }
        catch (Exception ex) {
            GUIHelper.showErrorMessage((Component)this.getOwner(), (String)("Failed to get setup from wizard!\n" + LoggingHelper.throwableToString((Throwable)ex)));
            return;
        }
        try {
            Flow flow = this.createFlow(input, loader, reader, ext, output);
            String msg = flow.setUp();
            if (msg != null) {
                GUIHelper.showErrorMessage((Component)this.getOwner(), (String)("Failed to setup flow!\n" + msg));
                return;
            }
            msg = flow.execute();
            if (msg != null) {
                GUIHelper.showErrorMessage((Component)this.getOwner(), (String)("Failed to execute flow!\n" + msg));
                flow.wrapUp();
                flow.cleanUp();
                return;
            }
            flow.wrapUp();
            flow.cleanUp();
        }
        catch (Exception e) {
            GUIHelper.showErrorMessage((Component)this.getOwner(), (String)("Failed to setup/execute flow!\n" + LoggingHelper.throwableToString((Throwable)e)));
            return;
        }
        GUIHelper.showInformationMessage(null, (String)("Data successfully generated in the following directory:\n" + props.getProperty("directory")));
        frame.dispose();
    }

    protected Flow createFlow(PlaceholderFile[] input, AbstractFileLoader loader, SpreadSheetReader reader, String ext, PlaceholderDirectory output) throws Exception {
        Flow actor = new Flow();
        ArrayList<Object> actors = new ArrayList<Object>();
        adams.flow.standalone.SetVariable setvariable = new adams.flow.standalone.SetVariable();
        AbstractArgumentOption argOption = (AbstractArgumentOption)setvariable.getOptionManager().findByProperty("name");
        setvariable.setName((String)argOption.valueOf("out dir"));
        argOption = (AbstractArgumentOption)setvariable.getOptionManager().findByProperty("variableName");
        setvariable.setVariableName((VariableName)argOption.valueOf("outdir"));
        argOption = (AbstractArgumentOption)setvariable.getOptionManager().findByProperty("variableValue");
        setvariable.setVariableValue((BaseText)argOption.valueOf(output.getAbsolutePath()));
        actors.add(setvariable);
        adams.flow.standalone.SetVariable setvariable2 = new adams.flow.standalone.SetVariable();
        argOption = (AbstractArgumentOption)setvariable2.getOptionManager().findByProperty("name");
        setvariable2.setName((String)argOption.valueOf("use adams spreadsheetreader"));
        argOption = (AbstractArgumentOption)setvariable2.getOptionManager().findByProperty("variableName");
        setvariable2.setVariableName((VariableName)argOption.valueOf("use_adams_spreader"));
        argOption = (AbstractArgumentOption)setvariable2.getOptionManager().findByProperty("variableValue");
        setvariable2.setVariableValue((BaseText)argOption.valueOf("false"));
        actors.add(setvariable2);
        Start start = new Start();
        actors.add(start);
        Trigger trigger = new Trigger();
        argOption = (AbstractArgumentOption)trigger.getOptionManager().findByProperty("name");
        trigger.setName((String)argOption.valueOf("load files"));
        ArrayList<Object> actors2 = new ArrayList<Object>();
        FileSupplier filesupplier = new FileSupplier();
        filesupplier.setOutputArray(true);
        filesupplier.setFiles(input);
        actors2.add(filesupplier);
        Tee tee = new Tee();
        argOption = (AbstractArgumentOption)tee.getOptionManager().findByProperty("name");
        tee.setName((String)argOption.valueOf("num files"));
        ArrayList<Object> actors3 = new ArrayList<Object>();
        ArrayLength arraylength = new ArrayLength();
        actors3.add(arraylength);
        SetVariable setvariable3 = new SetVariable();
        argOption = (AbstractArgumentOption)setvariable3.getOptionManager().findByProperty("variableName");
        setvariable3.setVariableName((VariableName)argOption.valueOf("num_files"));
        actors3.add(setvariable3);
        tee.setActors(actors3.toArray(new Actor[0]));
        actors2.add(tee);
        Trigger trigger2 = new Trigger();
        argOption = (AbstractArgumentOption)trigger2.getOptionManager().findByProperty("name");
        trigger2.setName((String)argOption.valueOf("new length array"));
        ArrayList<Object> actors4 = new ArrayList<Object>();
        NewArray newarray = new NewArray();
        argOption = (AbstractArgumentOption)newarray.getOptionManager().findByProperty("arrayClass");
        newarray.setArrayClass((String)argOption.valueOf("java.lang.Integer"));
        argOption = (AbstractArgumentOption)newarray.getOptionManager().findByProperty("dimensions");
        newarray.setDimensions((ArrayDimensions)argOption.valueOf("[@{num_files}]"));
        actors4.add(newarray);
        SetStorageValue setstoragevalue = new SetStorageValue();
        argOption = (AbstractArgumentOption)setstoragevalue.getOptionManager().findByProperty("storageName");
        setstoragevalue.setStorageName((StorageName)argOption.valueOf("lengths"));
        actors4.add(setstoragevalue);
        trigger2.setActors(actors4.toArray(new Actor[0]));
        actors2.add(trigger2);
        Trigger trigger3 = new Trigger();
        argOption = (AbstractArgumentOption)trigger3.getOptionManager().findByProperty("name");
        trigger3.setName((String)argOption.valueOf("new name array"));
        ArrayList<Object> actors5 = new ArrayList<Object>();
        NewArray newarray2 = new NewArray();
        argOption = (AbstractArgumentOption)newarray2.getOptionManager().findByProperty("dimensions");
        newarray2.setDimensions((ArrayDimensions)argOption.valueOf("[@{num_files}]"));
        actors5.add(newarray2);
        SetStorageValue setstoragevalue2 = new SetStorageValue();
        argOption = (AbstractArgumentOption)setstoragevalue2.getOptionManager().findByProperty("storageName");
        setstoragevalue2.setStorageName((StorageName)argOption.valueOf("names"));
        actors5.add(setstoragevalue2);
        trigger3.setActors(actors5.toArray(new Actor[0]));
        actors2.add(trigger3);
        SetVariable setvariable4 = new SetVariable();
        argOption = (AbstractArgumentOption)setvariable4.getOptionManager().findByProperty("variableName");
        setvariable4.setVariableName((VariableName)argOption.valueOf("index"));
        argOption = (AbstractArgumentOption)setvariable4.getOptionManager().findByProperty("variableValue");
        setvariable4.setVariableValue((BaseText)argOption.valueOf("0"));
        actors2.add(setvariable4);
        ArrayProcess arrayprocess = new ArrayProcess();
        ArrayList<Object> actors6 = new ArrayList<Object>();
        IncVariable incvariable = new IncVariable();
        argOption = (AbstractArgumentOption)incvariable.getOptionManager().findByProperty("variableName");
        incvariable.setVariableName((VariableName)argOption.valueOf("index"));
        actors6.add(incvariable);
        Tee tee2 = new Tee();
        argOption = (AbstractArgumentOption)tee2.getOptionManager().findByProperty("name");
        tee2.setName((String)argOption.valueOf("name"));
        ArrayList<Object> actors7 = new ArrayList<Object>();
        BaseName basename = new BaseName();
        basename.setRemoveExtension(true);
        actors7.add(basename);
        SetVariable setvariable5 = new SetVariable();
        argOption = (AbstractArgumentOption)setvariable5.getOptionManager().findByProperty("variableName");
        setvariable5.setVariableName((VariableName)argOption.valueOf("name"));
        actors7.add(setvariable5);
        Trigger trigger4 = new Trigger();
        argOption = (AbstractArgumentOption)trigger4.getOptionManager().findByProperty("name");
        trigger4.setName((String)argOption.valueOf("update array"));
        ArrayList<Object> actors8 = new ArrayList<Object>();
        StorageValue storagevalue = new StorageValue();
        argOption = (AbstractArgumentOption)storagevalue.getOptionManager().findByProperty("storageName");
        storagevalue.setStorageName((StorageName)argOption.valueOf("names"));
        actors8.add(storagevalue);
        SetArrayElement setarrayelement = new SetArrayElement();
        argOption = (AbstractArgumentOption)setarrayelement.getOptionManager().findByProperty("index");
        argOption.setVariable("@{index}");
        argOption = (AbstractArgumentOption)setarrayelement.getOptionManager().findByProperty("value");
        argOption.setVariable("@{name}");
        actors8.add(setarrayelement);
        SetStorageValue setstoragevalue3 = new SetStorageValue();
        argOption = (AbstractArgumentOption)setstoragevalue3.getOptionManager().findByProperty("storageName");
        setstoragevalue3.setStorageName((StorageName)argOption.valueOf("names"));
        actors8.add(setstoragevalue3);
        trigger4.setActors(actors8.toArray(new Actor[0]));
        actors7.add(trigger4);
        tee2.setActors(actors7.toArray(new Actor[0]));
        actors6.add(tee2);
        Tee tee3 = new Tee();
        argOption = (AbstractArgumentOption)tee3.getOptionManager().findByProperty("name");
        tee3.setName((String)argOption.valueOf("extension"));
        ArrayList<Object> actors9 = new ArrayList<Object>();
        FileExtension fileextension = new FileExtension();
        actors9.add(fileextension);
        SetVariable setvariable6 = new SetVariable();
        argOption = (AbstractArgumentOption)setvariable6.getOptionManager().findByProperty("variableName");
        setvariable6.setVariableName((VariableName)argOption.valueOf("extension"));
        actors9.add(setvariable6);
        tee3.setActors(actors9.toArray(new Actor[0]));
        actors6.add(tee3);
        Switch switch_ = new Switch();
        ArrayList<Expression> conditions = new ArrayList<Expression>();
        Expression expression = new Expression();
        argOption = (AbstractArgumentOption)expression.getOptionManager().findByProperty("expression");
        expression.setExpression((BooleanExpressionText)argOption.valueOf("(lower(\\\"@{extension}\\\") = \\\"" + ext + "\\\") and (@{use_adams_spreader} = " + (reader != null) + ")"));
        conditions.add(expression);
        switch_.setConditions(conditions.toArray(new BooleanCondition[0]));
        ArrayList<Object> cases = new ArrayList<Object>();
        SpreadSheetFileReader spreadsheetfilereader = new SpreadSheetFileReader();
        CsvSpreadSheetReader csvspreadsheetreader = new CsvSpreadSheetReader();
        DenseDataRow densedatarow = new DenseDataRow();
        csvspreadsheetreader.setDataRowType((DataRow)densedatarow);
        DefaultSpreadSheet spreadsheet = new DefaultSpreadSheet();
        csvspreadsheetreader.setSpreadSheetType((SpreadSheet)spreadsheet);
        if (reader != null) {
            spreadsheetfilereader.setReader(reader);
        } else {
            spreadsheetfilereader.setReader((SpreadSheetReader)csvspreadsheetreader);
        }
        cases.add(spreadsheetfilereader);
        SubProcess subprocess = new SubProcess();
        argOption = (AbstractArgumentOption)subprocess.getOptionManager().findByProperty("name");
        subprocess.setName((String)argOption.valueOf("weka"));
        ArrayList<WekaFileReader> actors10 = new ArrayList<WekaFileReader>();
        WekaFileReader wekafilereader = new WekaFileReader();
        wekafilereader.setUseCustomLoader(loader != null);
        AArffLoader aarffloader = new AArffLoader();
        if (loader != null) {
            wekafilereader.setCustomLoader(loader);
        } else {
            wekafilereader.setCustomLoader((AbstractFileLoader)aarffloader);
        }
        actors10.add(wekafilereader);
        Convert convert = new Convert();
        WekaInstancesToSpreadSheet wekainstancestospreadsheet = new WekaInstancesToSpreadSheet();
        DenseDataRow densedatarow2 = new DenseDataRow();
        wekainstancestospreadsheet.setDataRowType((DataRow)densedatarow2);
        DefaultSpreadSheet spreadsheet2 = new DefaultSpreadSheet();
        wekainstancestospreadsheet.setSpreadSheetType((SpreadSheet)spreadsheet2);
        convert.setConversion((Conversion)wekainstancestospreadsheet);
        actors10.add((WekaFileReader)convert);
        subprocess.setActors(actors10.toArray(new Actor[0]));
        cases.add(subprocess);
        switch_.setCases(cases.toArray(new Actor[0]));
        actors6.add(switch_);
        Tee tee4 = new Tee();
        argOption = (AbstractArgumentOption)tee4.getOptionManager().findByProperty("name");
        tee4.setName((String)argOption.valueOf("num rows"));
        ArrayList<Object> actors11 = new ArrayList<Object>();
        SpreadSheetInfo spreadsheetinfo = new SpreadSheetInfo();
        actors11.add(spreadsheetinfo);
        SetVariable setvariable7 = new SetVariable();
        argOption = (AbstractArgumentOption)setvariable7.getOptionManager().findByProperty("variableName");
        setvariable7.setVariableName((VariableName)argOption.valueOf("length"));
        actors11.add(setvariable7);
        Trigger trigger5 = new Trigger();
        argOption = (AbstractArgumentOption)trigger5.getOptionManager().findByProperty("name");
        trigger5.setName((String)argOption.valueOf("update array"));
        ArrayList<Object> actors12 = new ArrayList<Object>();
        StorageValue storagevalue2 = new StorageValue();
        argOption = (AbstractArgumentOption)storagevalue2.getOptionManager().findByProperty("storageName");
        storagevalue2.setStorageName((StorageName)argOption.valueOf("lengths"));
        actors12.add(storagevalue2);
        SetArrayElement setarrayelement2 = new SetArrayElement();
        argOption = (AbstractArgumentOption)setarrayelement2.getOptionManager().findByProperty("index");
        argOption.setVariable("@{index}");
        argOption = (AbstractArgumentOption)setarrayelement2.getOptionManager().findByProperty("value");
        argOption.setVariable("@{length}");
        actors12.add(setarrayelement2);
        SetStorageValue setstoragevalue4 = new SetStorageValue();
        argOption = (AbstractArgumentOption)setstoragevalue4.getOptionManager().findByProperty("storageName");
        setstoragevalue4.setStorageName((StorageName)argOption.valueOf("lengths"));
        actors12.add(setstoragevalue4);
        trigger5.setActors(actors12.toArray(new Actor[0]));
        actors11.add(trigger5);
        tee4.setActors(actors11.toArray(new Actor[0]));
        actors6.add(tee4);
        arrayprocess.setActors(actors6.toArray(new Actor[0]));
        actors2.add(arrayprocess);
        SetStorageValue setstoragevalue5 = new SetStorageValue();
        argOption = (AbstractArgumentOption)setstoragevalue5.getOptionManager().findByProperty("storageName");
        setstoragevalue5.setStorageName((StorageName)argOption.valueOf("sheets"));
        actors2.add(setstoragevalue5);
        trigger.setActors(actors2.toArray(new Actor[0]));
        actors.add(trigger);
        Trigger trigger6 = new Trigger();
        argOption = (AbstractArgumentOption)trigger6.getOptionManager().findByProperty("name");
        trigger6.setName((String)argOption.valueOf("combine files"));
        ArrayList<Object> actors13 = new ArrayList<Object>();
        StorageValue storagevalue3 = new StorageValue();
        argOption = (AbstractArgumentOption)storagevalue3.getOptionManager().findByProperty("storageName");
        storagevalue3.setStorageName((StorageName)argOption.valueOf("sheets"));
        actors13.add(storagevalue3);
        ArrayToSequence arraytosequence = new ArrayToSequence();
        actors13.add(arraytosequence);
        SpreadSheetAppend spreadsheetappend = new SpreadSheetAppend();
        spreadsheetappend.setNoCopy(true);
        argOption = (AbstractArgumentOption)spreadsheetappend.getOptionManager().findByProperty("storageName");
        spreadsheetappend.setStorageName((StorageName)argOption.valueOf("combined_sheets"));
        actors13.add(spreadsheetappend);
        trigger6.setActors(actors13.toArray(new Actor[0]));
        actors.add(trigger6);
        Trigger trigger7 = new Trigger();
        argOption = (AbstractArgumentOption)trigger7.getOptionManager().findByProperty("name");
        trigger7.setName((String)argOption.valueOf("create combined arff"));
        ArrayList<Object> actors14 = new ArrayList<Object>();
        StorageValue storagevalue4 = new StorageValue();
        argOption = (AbstractArgumentOption)storagevalue4.getOptionManager().findByProperty("storageName");
        storagevalue4.setStorageName((StorageName)argOption.valueOf("combined_sheets"));
        actors14.add(storagevalue4);
        Convert convert2 = new Convert();
        SpreadSheetToWekaInstances spreadsheettowekainstances = new SpreadSheetToWekaInstances();
        convert2.setConversion((Conversion)spreadsheettowekainstances);
        actors14.add(convert2);
        SetStorageValue setstoragevalue6 = new SetStorageValue();
        argOption = (AbstractArgumentOption)setstoragevalue6.getOptionManager().findByProperty("storageName");
        setstoragevalue6.setStorageName((StorageName)argOption.valueOf("combined_arff"));
        actors14.add(setstoragevalue6);
        trigger7.setActors(actors14.toArray(new Actor[0]));
        actors.add(trigger7);
        Trigger trigger8 = new Trigger();
        argOption = (AbstractArgumentOption)trigger8.getOptionManager().findByProperty("name");
        trigger8.setName((String)argOption.valueOf("create separate arff"));
        ArrayList<Object> actors15 = new ArrayList<Object>();
        StorageForLoop storageforloop = new StorageForLoop();
        argOption = (AbstractArgumentOption)storageforloop.getOptionManager().findByProperty("loopUpper");
        argOption.setVariable("@{num_files}");
        argOption = (AbstractArgumentOption)storageforloop.getOptionManager().findByProperty("variableName");
        storageforloop.setVariableName((VariableName)argOption.valueOf("index"));
        argOption = (AbstractArgumentOption)storageforloop.getOptionManager().findByProperty("storageName");
        storageforloop.setStorageName((StorageName)argOption.valueOf("combined_arff"));
        actors15.add(storageforloop);
        Trigger trigger9 = new Trigger();
        argOption = (AbstractArgumentOption)trigger9.getOptionManager().findByProperty("name");
        trigger9.setName((String)argOption.valueOf("get name"));
        ArrayList<Object> actors16 = new ArrayList<Object>();
        StorageValue storagevalue5 = new StorageValue();
        argOption = (AbstractArgumentOption)storagevalue5.getOptionManager().findByProperty("storageName");
        storagevalue5.setStorageName((StorageName)argOption.valueOf("names"));
        actors16.add(storagevalue5);
        GetArrayElement getarrayelement = new GetArrayElement();
        argOption = (AbstractArgumentOption)getarrayelement.getOptionManager().findByProperty("index");
        argOption.setVariable("@{index}");
        actors16.add(getarrayelement);
        SetVariable setvariable8 = new SetVariable();
        argOption = (AbstractArgumentOption)setvariable8.getOptionManager().findByProperty("variableName");
        setvariable8.setVariableName((VariableName)argOption.valueOf("name"));
        actors16.add(setvariable8);
        trigger9.setActors(actors16.toArray(new Actor[0]));
        actors15.add(trigger9);
        Trigger trigger10 = new Trigger();
        argOption = (AbstractArgumentOption)trigger10.getOptionManager().findByProperty("name");
        trigger10.setName((String)argOption.valueOf("get length"));
        ArrayList<Object> actors17 = new ArrayList<Object>();
        StorageValue storagevalue6 = new StorageValue();
        argOption = (AbstractArgumentOption)storagevalue6.getOptionManager().findByProperty("storageName");
        storagevalue6.setStorageName((StorageName)argOption.valueOf("lengths"));
        actors17.add(storagevalue6);
        GetArrayElement getarrayelement2 = new GetArrayElement();
        argOption = (AbstractArgumentOption)getarrayelement2.getOptionManager().findByProperty("index");
        argOption.setVariable("@{index}");
        actors17.add(getarrayelement2);
        SetVariable setvariable9 = new SetVariable();
        argOption = (AbstractArgumentOption)setvariable9.getOptionManager().findByProperty("variableName");
        setvariable9.setVariableName((VariableName)argOption.valueOf("length"));
        actors17.add(setvariable9);
        trigger10.setActors(actors17.toArray(new Actor[0]));
        actors15.add(trigger10);
        Trigger trigger11 = new Trigger();
        argOption = (AbstractArgumentOption)trigger11.getOptionManager().findByProperty("name");
        trigger11.setName((String)argOption.valueOf("create range"));
        ArrayList<Object> actors18 = new ArrayList<Object>();
        CombineVariables combinevariables = new CombineVariables();
        argOption = (AbstractArgumentOption)combinevariables.getOptionManager().findByProperty("expression");
        combinevariables.setExpression((BaseText)argOption.valueOf("1-@{length}"));
        actors18.add(combinevariables);
        SetVariable setvariable10 = new SetVariable();
        argOption = (AbstractArgumentOption)setvariable10.getOptionManager().findByProperty("variableName");
        setvariable10.setVariableName((VariableName)argOption.valueOf("range"));
        actors18.add(setvariable10);
        trigger11.setActors(actors18.toArray(new Actor[0]));
        actors15.add(trigger11);
        Trigger trigger12 = new Trigger();
        argOption = (AbstractArgumentOption)trigger12.getOptionManager().findByProperty("name");
        trigger12.setName((String)argOption.valueOf("output file"));
        ArrayList<Object> actors19 = new ArrayList<Object>();
        CombineVariables combinevariables2 = new CombineVariables();
        argOption = (AbstractArgumentOption)combinevariables2.getOptionManager().findByProperty("expression");
        combinevariables2.setExpression((BaseText)argOption.valueOf("@{name}.arff"));
        actors19.add(combinevariables2);
        PrependDir prependdir = new PrependDir();
        argOption = (AbstractArgumentOption)prependdir.getOptionManager().findByProperty("prefix");
        argOption.setVariable("@{outdir}");
        actors19.add(prependdir);
        SetVariable setvariable11 = new SetVariable();
        argOption = (AbstractArgumentOption)setvariable11.getOptionManager().findByProperty("variableName");
        setvariable11.setVariableName((VariableName)argOption.valueOf("outfile"));
        actors19.add(setvariable11);
        trigger12.setActors(actors19.toArray(new Actor[0]));
        actors15.add(trigger12);
        Tee teeSave = new Tee();
        teeSave.setName("save ARFF");
        actors15.add(teeSave);
        UpdateProperties updateproperties = new UpdateProperties();
        argOption = (AbstractArgumentOption)updateproperties.getOptionManager().findByProperty("properties");
        ArrayList<BaseString> properties = new ArrayList<BaseString>();
        properties.add((BaseString)argOption.valueOf("filter.instancesIndices"));
        updateproperties.setProperties(properties.toArray(new BaseString[0]));
        argOption = (AbstractArgumentOption)updateproperties.getOptionManager().findByProperty("variableNames");
        ArrayList<VariableName> variablenames = new ArrayList<VariableName>();
        variablenames.add((VariableName)argOption.valueOf("range"));
        updateproperties.setVariableNames(variablenames.toArray(new VariableName[0]));
        WekaFilter wekafilter = new WekaFilter();
        RemoveRange removerange = new RemoveRange();
        removerange.setOptions(OptionUtils.splitOptions((String)"-V -R first-last"));
        wekafilter.setFilter((Filter)removerange);
        updateproperties.setSubActor((Actor)wekafilter);
        teeSave.add((Actor)updateproperties);
        WekaRenameRelation wekarenamerelation = new WekaRenameRelation();
        argOption = (AbstractArgumentOption)wekarenamerelation.getOptionManager().findByProperty("replace");
        argOption.setVariable("@{name}");
        teeSave.add((Actor)wekarenamerelation);
        WekaFileWriter wekafilewriter = new WekaFileWriter();
        argOption = (AbstractArgumentOption)wekafilewriter.getOptionManager().findByProperty("outputFile");
        argOption.setVariable("@{outfile}");
        ArffSaver arffsaver = new ArffSaver();
        arffsaver.setOptions(OptionUtils.splitOptions((String)"-decimal 6"));
        wekafilewriter.setCustomSaver((AbstractFileSaver)arffsaver);
        teeSave.add((Actor)wekafilewriter);
        SubProcess subUpdate = new SubProcess();
        subUpdate.setName("update dataset");
        actors15.add(subUpdate);
        UpdateProperties updateproperties2 = new UpdateProperties();
        argOption = (AbstractArgumentOption)updateproperties2.getOptionManager().findByProperty("properties");
        ArrayList<BaseString> properties2 = new ArrayList<BaseString>();
        properties2.add((BaseString)argOption.valueOf("filter.instancesIndices"));
        updateproperties2.setProperties(properties2.toArray(new BaseString[0]));
        argOption = (AbstractArgumentOption)updateproperties2.getOptionManager().findByProperty("variableNames");
        ArrayList<VariableName> variablenames2 = new ArrayList<VariableName>();
        variablenames2.add((VariableName)argOption.valueOf("range"));
        updateproperties2.setVariableNames(variablenames2.toArray(new VariableName[0]));
        WekaFilter wekafilter2 = new WekaFilter();
        RemoveRange removerange2 = new RemoveRange();
        removerange2.setOptions(OptionUtils.splitOptions((String)"-R first-last"));
        wekafilter2.setFilter((Filter)removerange2);
        updateproperties2.setSubActor((Actor)wekafilter2);
        subUpdate.add((Actor)updateproperties2);
        SetStorageValue setstoragevalue62 = new SetStorageValue();
        argOption = (AbstractArgumentOption)setstoragevalue62.getOptionManager().findByProperty("storageName");
        setstoragevalue62.setStorageName((StorageName)argOption.valueOf("combined_arff"));
        subUpdate.add((Actor)setstoragevalue62);
        trigger8.setActors(actors15.toArray(new Actor[0]));
        actors.add(trigger8);
        actor.setActors(actors.toArray(new Actor[0]));
        NullListener nulllistener = new NullListener();
        actor.setFlowExecutionListener((FlowExecutionListener)nulllistener);
        return actor;
    }

    public String getTitle() {
        return "WEKA Make compatible datasets";
    }

    public boolean isSingleton() {
        return false;
    }

    public UserMode getUserMode() {
        return UserMode.BASIC;
    }

    public String getCategory() {
        return "Tools";
    }
}

