/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.menu;

import adams.core.Properties;
import adams.core.Utils;
import adams.core.logging.LoggingHelper;
import adams.core.option.OptionUtils;
import adams.core.option.UserMode;
import adams.flow.core.Token;
import adams.flow.transformer.WekaInstancesMerge;
import adams.flow.transformer.WekaMergeInstancesActor;
import adams.gui.application.AbstractApplicationFrame;
import adams.gui.application.AbstractBasicMenuItemDefinition;
import adams.gui.application.ChildFrame;
import adams.gui.core.GUIHelper;
import adams.gui.wizard.AbstractWizardPage;
import adams.gui.wizard.FinalPage;
import adams.gui.wizard.GenericObjectEditorPage;
import adams.gui.wizard.PageCheck;
import adams.gui.wizard.WekaSelectDatasetPage;
import adams.gui.wizard.WekaSelectMultipleDatasetsPage;
import adams.gui.wizard.WizardPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.logging.Level;
import weka.core.Instances;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.ConverterUtils;
import weka.core.converters.Loader;

public class MergeDatasets
extends AbstractBasicMenuItemDefinition {
    private static final long serialVersionUID = 7586443345167287461L;

    public MergeDatasets() {
        this(null);
    }

    public MergeDatasets(AbstractApplicationFrame owner) {
        super(owner);
    }

    public String getIconName() {
        return "merge.png";
    }

    public void launch() {
        WekaInstancesMerge merge = new WekaInstancesMerge();
        final WizardPane wizard = new WizardPane();
        wizard.setCustomFinishText("Merge");
        WekaSelectMultipleDatasetsPage infiles = new WekaSelectMultipleDatasetsPage("Input");
        infiles.setDescription("Select the Weka datasets to merge (side-by-side).\nYou have to choose at least two.");
        infiles.setPageCheck(new PageCheck(){

            public boolean checkPage(AbstractWizardPage page) {
                Properties props = page.getProperties();
                try {
                    String[] files = OptionUtils.splitOptions((String)props.getProperty("files"));
                    return files.length >= 2;
                }
                catch (Exception e) {
                    MergeDatasets.this.getLogger().log(Level.SEVERE, "Failed to obtain files:", (Throwable)e);
                    return false;
                }
            }
        });
        wizard.addPage((AbstractWizardPage)infiles);
        GenericObjectEditorPage goe = new GenericObjectEditorPage("Setup");
        goe.setDescription("Specify how the files should get merged.");
        goe.setClassType(WekaMergeInstancesActor.class);
        goe.setCanChangeClassInDialog(true);
        goe.setValue((Object)merge);
        wizard.addPage((AbstractWizardPage)goe);
        WekaSelectDatasetPage outfile = new WekaSelectDatasetPage("Output");
        outfile.setDescription("Select the file to save the merged data to.");
        outfile.setUseSaveDialog(true);
        wizard.addPage((AbstractWizardPage)outfile);
        FinalPage finalpage = new FinalPage();
        finalpage.setLogo(null);
        finalpage.setDescription("<html><h2>Ready</h2>Please click on <b>Merge</b> to start the process.</html>");
        wizard.addPage((AbstractWizardPage)finalpage);
        final ChildFrame frame = this.createChildFrame((Component)wizard, GUIHelper.makeWider((Dimension)GUIHelper.getDefaultDialogDimension()));
        wizard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!e.getActionCommand().equals("Finish")) {
                    frame.dispose();
                    return;
                }
                Properties props = wizard.getProperties(false);
                File[] input = null;
                File output = null;
                WekaMergeInstancesActor merge = null;
                try {
                    String[] files = OptionUtils.splitOptions((String)props.getProperty("files"));
                    input = new File[files.length];
                    for (int i = 0; i < files.length; ++i) {
                        input[i] = new File(files[i]);
                    }
                    merge = (WekaMergeInstancesActor)OptionUtils.forCommandLine(WekaMergeInstancesActor.class, (String)props.getProperty("Commandline"));
                    output = new File(props.getProperty("file"));
                }
                catch (Exception ex) {
                    GUIHelper.showErrorMessage((Component)MergeDatasets.this.getOwner(), (String)("Failed to get setup from wizard!\n" + LoggingHelper.throwableToString((Throwable)ex)));
                    return;
                }
                MergeDatasets.this.doMerge(frame, input, merge, output);
            }
        });
        wizard.update();
    }

    protected void doMerge(ChildFrame frame, File[] input, WekaMergeInstancesActor merge, File output) {
        if (input.length < 2) {
            GUIHelper.showErrorMessage((Component)this.getOwner(), (String)"At least two files are required!");
            return;
        }
        AbstractFileLoader loader = ConverterUtils.getLoaderForFile((File)input[0]);
        Instances[] data = new Instances[input.length];
        for (int i = 0; i < input.length; ++i) {
            try {
                loader.setFile(input[i]);
                data[i] = ConverterUtils.DataSource.read((Loader)loader);
                continue;
            }
            catch (Exception e) {
                GUIHelper.showErrorMessage((Component)this.getOwner(), (String)("Failed to read '" + input[i] + "'!\n" + LoggingHelper.throwableToString((Throwable)e)));
                return;
            }
        }
        String msg = merge.setUp();
        if (msg != null) {
            GUIHelper.showErrorMessage((Component)this.getOwner(), (String)("Failed to set up merge actor!\n" + msg));
            return;
        }
        Token token = new Token((Object)data);
        merge.input(token);
        msg = merge.execute();
        if (msg != null) {
            GUIHelper.showErrorMessage((Component)this.getOwner(), (String)("Failed to merge files!\n" + Utils.flatten((Object[])input, (String)"\n") + "\n\n" + msg));
            return;
        }
        token = merge.output();
        Instances full = (Instances)token.getPayload();
        try {
            ConverterUtils.DataSink sink = new ConverterUtils.DataSink(output.getAbsolutePath());
            sink.write(full);
        }
        catch (Exception e) {
            GUIHelper.showErrorMessage((Component)this.getOwner(), (String)("Failed to save data to '" + output + "'!\n" + LoggingHelper.throwableToString((Throwable)e)));
            return;
        }
        GUIHelper.showInformationMessage(null, (String)("Successfully merged!\n" + output));
        frame.dispose();
    }

    public String getTitle() {
        return "WEKA Merge datasets";
    }

    public boolean isSingleton() {
        return false;
    }

    public UserMode getUserMode() {
        return UserMode.BASIC;
    }

    public String getCategory() {
        return "Tools";
    }
}

