/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.menu;

import adams.core.ClassLister;
import adams.core.logging.LoggingLevel;
import adams.core.option.UserMode;
import adams.gui.application.AbstractApplicationFrame;
import adams.gui.core.ConsolePanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.GUIPrompt;
import adams.gui.menu.AbstractWekaMenuItemDefinition;
import java.awt.Component;
import java.io.OutputStream;
import java.io.PrintStream;
import weka.core.WekaPackageManager;

public class PackageManager
extends AbstractWekaMenuItemDefinition {
    private static final long serialVersionUID = 3941702242700593202L;
    public static final String PROMPT = "StaticClassDiscoveryPackageManagerPrompted";

    public PackageManager() {
        this(null);
    }

    public PackageManager(AbstractApplicationFrame owner) {
        super(owner);
    }

    public void launch() {
        int retVal = 0;
        if (ClassLister.getSingleton().isStatic() && !GUIPrompt.getSingleton().getBoolean(PROMPT, false)) {
            retVal = GUIHelper.showConfirmMessage(null, (String)"Class discovery is set to static use. If you want to use additional Weka packages, you need to enable dynamic discovery again.\nSee adams-core-manual.pdf, chapter 'Applications without dynamic class discovery'.");
            GUIPrompt.getSingleton().setBoolean(PROMPT, retVal == 0);
        }
        if (retVal != 0) {
            return;
        }
        WekaPackageManager.establishCacheIfNeeded((PrintStream[])new PrintStream[]{new PrintStream((OutputStream)new ConsolePanel.ConsolePanelOutputStream(LoggingLevel.INFO))});
        this.createChildFrame((Component)new weka.gui.PackageManager(), GUIHelper.getDefaultDialogDimension());
    }

    public String getTitle() {
        return "WEKA Package manager";
    }

    public boolean isSingleton() {
        return true;
    }

    public UserMode getUserMode() {
        return UserMode.EXPERT;
    }

    @Override
    public String getCategory() {
        return "Tools";
    }
}

