/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.data;

import adams.gui.tools.wekainvestigator.data.DataContainer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;

public class DataContainerList
extends ArrayList<DataContainer> {
    private static final long serialVersionUID = 8763903971623553841L;
    protected boolean m_UndoEnabled;

    public synchronized void setUndoEnabled(boolean value) {
        this.m_UndoEnabled = value;
        for (DataContainer cont : this) {
            cont.getUndo().setEnabled(value);
        }
    }

    public boolean isUndoEnabled() {
        return this.m_UndoEnabled;
    }

    @Override
    public boolean add(DataContainer cont) {
        cont.getUndo().setEnabled(this.isUndoEnabled());
        return super.add(cont);
    }

    @Override
    public boolean addAll(Collection<? extends DataContainer> c) {
        for (DataContainer dataContainer : c) {
            dataContainer.getUndo().setEnabled(this.isUndoEnabled());
        }
        return super.addAll(c);
    }

    @Override
    public DataContainer set(int index, DataContainer element) {
        ((DataContainer)this.get(index)).cleanUp();
        return super.set(index, element);
    }

    @Override
    public boolean remove(Object o) {
        ((DataContainer)o).cleanUp();
        return super.remove(o);
    }

    @Override
    public DataContainer remove(int index) {
        ((DataContainer)this.get(index)).cleanUp();
        return (DataContainer)super.remove(index);
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        for (int i = fromIndex; i < toIndex; ++i) {
            ((DataContainer)this.get(i)).cleanUp();
        }
        super.removeRange(fromIndex, toIndex);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return super.removeAll(c);
    }

    @Override
    public boolean removeIf(Predicate<? super DataContainer> filter) {
        return super.removeIf(filter);
    }

    @Override
    public void clear() {
        for (DataContainer c : this) {
            c.cleanUp();
        }
        super.clear();
    }
}

