/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.data;

import adams.core.option.OptionUtils;
import adams.gui.tools.wekainvestigator.data.AbstractDataContainer;
import java.io.Serializable;
import weka.core.Instances;
import weka.datagenerators.DataGenerator;

public class DataGeneratorContainer
extends AbstractDataContainer {
    private static final long serialVersionUID = 6267905940957451551L;
    protected DataGenerator m_Generator;

    public DataGeneratorContainer(DataGenerator generator) {
        try {
            generator.defineDataFormat();
            this.m_Data = generator.generateExamples();
            this.m_Generator = generator;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to generate dataset: " + OptionUtils.getCommandLine((Object)generator), e);
        }
    }

    @Override
    public String getSource() {
        if (this.m_Generator == null) {
            return "<unknown>";
        }
        return OptionUtils.getCommandLine((Object)this.m_Generator);
    }

    @Override
    public boolean canReload() {
        return this.m_Generator != null;
    }

    @Override
    protected String doReload() {
        try {
            this.m_Generator.defineDataFormat();
            this.m_Data = this.m_Generator.generateExamples();
            return null;
        }
        catch (Exception e) {
            return this.handleException("Failed to regenerate data: " + OptionUtils.getCommandLine((Object)this.m_Generator), e);
        }
    }

    @Override
    protected Serializable[] getUndoData() {
        return new Serializable[]{this.m_Data, Boolean.valueOf(this.m_Modified), this.m_Generator};
    }

    @Override
    protected void applyUndoData(Serializable[] data) {
        this.m_Data = (Instances)data[0];
        this.m_Modified = (Boolean)data[1];
        this.m_Generator = (DataGenerator)data[2];
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        this.m_Generator = null;
    }
}

