/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.data;

import adams.core.io.PlaceholderFile;
import adams.core.io.filechanged.FileChangeMonitor;
import adams.core.io.filechanged.LastModified;
import adams.gui.tools.wekainvestigator.data.AbstractDataContainer;
import adams.gui.tools.wekainvestigator.data.MonitoringDataContainer;
import java.io.File;
import java.io.Serializable;
import weka.core.Instances;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.ConverterUtils;
import weka.core.converters.Loader;

public class FileContainer
extends AbstractDataContainer
implements MonitoringDataContainer {
    private static final long serialVersionUID = 6267905940957451551L;
    protected File m_Source;
    protected AbstractFileLoader m_Loader;
    protected FileChangeMonitor m_Monitor;

    public FileContainer(AbstractFileLoader loader, PlaceholderFile source) {
        this(loader, (File)source);
    }

    public FileContainer(AbstractFileLoader loader, File source) {
        try {
            if (loader.retrieveFile() == null || !loader.retrieveFile().getAbsoluteFile().equals(source.getAbsoluteFile())) {
                loader.setFile(source.getAbsoluteFile());
            }
            this.m_Data = loader.getDataSet();
            this.m_Source = source;
            this.m_Loader = loader;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to load dataset: " + source, e);
        }
        this.m_Monitor = new LastModified();
        this.m_Monitor.initialize(source);
    }

    public FileContainer(AbstractFileLoader loader, File source, Instances data) {
        try {
            this.m_Data = data;
            this.m_Source = source;
            this.m_Loader = loader;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to load dataset: " + source, e);
        }
        this.m_Monitor = new LastModified();
        this.m_Monitor.initialize(source);
    }

    @Override
    public String getSource() {
        if (this.m_Source == null) {
            return "<unknown>";
        }
        return this.m_Source.toString();
    }

    @Override
    public boolean canReload() {
        return this.m_Loader != null && this.m_Source != null && this.m_Source.exists();
    }

    @Override
    protected String doReload() {
        if (!this.m_Source.getAbsoluteFile().exists()) {
            return "File does not exist: " + this.m_Source.getAbsoluteFile();
        }
        try {
            this.m_Loader.setFile(this.m_Source.getAbsoluteFile());
            ConverterUtils.DataSource source = new ConverterUtils.DataSource((Loader)this.m_Loader);
            this.m_Data = source.getDataSet();
            return null;
        }
        catch (Exception e) {
            return this.handleException("Failed to reload: " + this.m_Source, e);
        }
    }

    @Override
    public void setModified(boolean value) {
        super.setModified(value);
        if (this.m_Source != null && this.m_Source.exists() && this.m_Source.isFile()) {
            this.m_Monitor.update(this.m_Source.getAbsoluteFile());
        }
    }

    @Override
    public boolean hasSourceChanged() {
        if (this.m_Source != null && this.m_Source.exists() && this.m_Source.isFile()) {
            return this.m_Monitor.hasChanged(this.m_Source.getAbsoluteFile());
        }
        return false;
    }

    @Override
    protected Serializable[] getUndoData() {
        return new Serializable[]{this.m_Data, Boolean.valueOf(this.m_Modified), this.m_Loader, this.m_Source};
    }

    @Override
    protected void applyUndoData(Serializable[] data) {
        this.m_Data = (Instances)data[0];
        this.m_Modified = (Boolean)data[1];
        this.m_Loader = (AbstractFileLoader)data[2];
        this.m_Source = (File)data[3];
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        this.m_Loader = null;
        this.m_Source = null;
    }
}

