/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.data;

import adams.core.option.OptionUtils;
import adams.gui.tools.wekainvestigator.data.AbstractDataContainer;
import java.io.Serializable;
import weka.core.Instances;
import weka.core.converters.TextDirectoryLoader;

public class TextDirectoryLoaderContainer
extends AbstractDataContainer {
    private static final long serialVersionUID = 6267905940957451551L;
    protected TextDirectoryLoader m_Loader;

    public TextDirectoryLoaderContainer(TextDirectoryLoader loader) {
        try {
            this.m_Data = loader.getDataSet();
            this.m_Loader = loader;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to load text data: " + OptionUtils.getCommandLine((Object)loader), e);
        }
    }

    @Override
    public String getSource() {
        if (this.m_Loader == null) {
            return "<unknown>";
        }
        return OptionUtils.getCommandLine((Object)this.m_Loader);
    }

    @Override
    public boolean canReload() {
        return this.m_Loader != null;
    }

    @Override
    protected String doReload() {
        if (!this.m_Loader.getDirectory().exists()) {
            return "Directory does not exist: " + this.m_Loader.getDirectory();
        }
        try {
            this.m_Data = this.m_Loader.getDataSet();
            return null;
        }
        catch (Exception e) {
            return this.handleException("Failed to regenerate data: " + OptionUtils.getCommandLine((Object)this.m_Loader), e);
        }
    }

    @Override
    protected Serializable[] getUndoData() {
        return new Serializable[]{this.m_Data, Boolean.valueOf(this.m_Modified), this.m_Loader};
    }

    @Override
    protected void applyUndoData(Serializable[] data) {
        this.m_Data = (Instances)data[0];
        this.m_Modified = (Boolean)data[1];
        this.m_Loader = (TextDirectoryLoader)data[2];
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        this.m_Loader = null;
    }
}

