/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.datatable;

import adams.gui.core.BaseComboBox;
import adams.gui.core.BaseTable;
import adams.gui.core.SortableAndSearchableWrapperTableModel;
import adams.gui.tools.wekainvestigator.data.DataContainer;
import adams.gui.tools.wekainvestigator.datatable.DataTableModel;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import nz.ac.waikato.cms.locator.StringCompare;

public class DataTable
extends BaseTable {
    private static final long serialVersionUID = -2329794525513037246L;
    public static final int MAX_COLUMN_WIDTH = 300;
    protected boolean m_SortAttributes;

    public DataTable(DataTableModel dm) {
        super((TableModel)((Object)dm));
    }

    protected void initGUI() {
        super.initGUI();
        this.m_SortAttributes = true;
        this.addHeaderPopupMenuListener(e -> {
            JPopupMenu menu = new JPopupMenu();
            JMenuItem menuitem = new JMenuItem("Optimal width");
            menuitem.addActionListener(ae -> this.setOptimalColumnWidthBounded(300));
            menu.add(menuitem);
            menu.show(this.getTableHeader(), e.getX(), e.getY());
        });
    }

    protected void afterTableLayoutChanged() {
        this.setOptimalColumnWidthBounded(300);
    }

    public void setSortAttributes(boolean value) {
        this.m_SortAttributes = value;
    }

    public boolean getSortAttributes() {
        return this.m_SortAttributes;
    }

    public TableCellEditor getCellEditor(int row, int column) {
        TableCellEditor result = null;
        if (column == 3) {
            TableModel model = this.getModel();
            DataTableModel dmodel = model instanceof SortableAndSearchableWrapperTableModel ? (DataTableModel)((Object)((SortableAndSearchableWrapperTableModel)model).getUnsortedModel()) : (DataTableModel)((Object)model);
            DataContainer cont = dmodel.getData().get(row);
            ArrayList<String> atts = new ArrayList<String>();
            for (int i = 0; i < cont.getData().numAttributes(); ++i) {
                atts.add(cont.getData().attribute(i).name());
            }
            if (this.m_SortAttributes) {
                Collections.sort(atts, new StringCompare());
            }
            atts.add(0, "");
            BaseComboBox combobox = new BaseComboBox((Object[])atts.toArray(new String[atts.size()]));
            result = new DefaultCellEditor((JComboBox<?>)combobox);
        }
        if (result == null) {
            result = super.getCellEditor(row, column);
        }
        return result;
    }
}

