/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.datatable.action;

import adams.core.option.OptionUtils;
import adams.data.weka.WekaAttributeIndex;
import adams.gui.core.BaseComboBox;
import adams.gui.core.GUIHelper;
import adams.gui.core.IndexTextField;
import adams.gui.core.ParameterPanel;
import adams.gui.dialog.ApprovalDialog;
import adams.gui.event.WekaInvestigatorDataEvent;
import adams.gui.tools.wekainvestigator.data.DataContainer;
import adams.gui.tools.wekainvestigator.data.MemoryContainer;
import adams.gui.tools.wekainvestigator.datatable.action.AbstractEditableDataTableAction;
import adams.gui.tools.wekainvestigator.evaluation.DatasetHelper;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import weka.core.Instances;
import weka.filters.Filter;
import weka.filters.unsupervised.instance.RemoveTestInstances;

public class RemoveTestSet
extends AbstractEditableDataTableAction {
    private static final long serialVersionUID = -8374323161691034031L;
    protected String m_LastSourceID;
    protected String m_LastTestSetID;

    public RemoveTestSet() {
        this.setName("Remove test set");
        this.setAsynchronous(true);
    }

    protected void doActionPerformed(ActionEvent e) {
        MemoryContainer newCont;
        DataContainer contSource = this.getSelectedData()[0];
        ParameterPanel params = new ParameterPanel();
        IndexTextField textSourceID = new IndexTextField("1");
        params.addParameter("ID attribute in source", (Component)textSourceID);
        BaseComboBox comboTestSet = new BaseComboBox(DatasetHelper.generateDatasetList(this.getOwner().getData()));
        int contTestSetIndex = 0;
        for (int i = 0; i < this.getData().size(); ++i) {
            if (((DataContainer)this.getData().get(i)).getID() == contSource.getID()) continue;
            contTestSetIndex = i;
            break;
        }
        comboTestSet.setSelectedIndex(contTestSetIndex);
        params.addParameter("Test set", (Component)comboTestSet);
        IndexTextField textTestSetID = new IndexTextField("1");
        params.addParameter("ID attribute in test set", (Component)textTestSetID);
        ApprovalDialog dialog = GUIHelper.getParentDialog((Container)((Object)this.getOwner())) != null ? new ApprovalDialog(GUIHelper.getParentDialog((Container)((Object)this.getOwner())), Dialog.ModalityType.DOCUMENT_MODAL) : new ApprovalDialog(GUIHelper.getParentFrame((Container)((Object)this.getOwner())), true);
        dialog.setTitle("Remove test set");
        dialog.getContentPane().add((Component)params, "Center");
        dialog.pack(null, GUIHelper.getDefaultSmallDialogDimension());
        dialog.setLocationRelativeTo((Component)((Object)this.getOwner().getOwner()));
        dialog.setVisible(true);
        if (dialog.getOption() != 0) {
            return;
        }
        String sourceID = textSourceID.getText();
        contTestSetIndex = comboTestSet.getSelectedIndex();
        DataContainer contTestSet = (DataContainer)this.getData().get(contTestSetIndex);
        String testSetID = textTestSetID.getText();
        this.m_LastSourceID = sourceID;
        this.m_LastTestSetID = testSetID;
        this.logMessage("Remove test set: " + contSource.getID() + "/" + contSource.getData().relationName() + " [" + contSource.getSource() + "]");
        RemoveTestInstances filter = new RemoveTestInstances();
        filter.setID(new WekaAttributeIndex(sourceID));
        filter.setIDTest(new WekaAttributeIndex(testSetID));
        filter.setSuppliedTestSet(contTestSet.getData());
        this.logMessage("Filter setup: " + OptionUtils.getCommandLine((Object)((Object)filter)));
        try {
            filter.setInputFormat(contSource.getData());
            newCont = new MemoryContainer(Filter.useFilter((Instances)contSource.getData(), (Filter)filter));
        }
        catch (Exception ex) {
            GUIHelper.showErrorMessage((Component)((Object)this.getOwner()), (String)"Failed to remove test set!", (Throwable)ex);
            return;
        }
        this.getData().add(newCont);
        this.logMessage("Successfully removed test set from " + contSource.getID() + " and added " + newCont.getID() + "!");
        this.fireDataChange(new WekaInvestigatorDataEvent(this.getOwner().getOwner(), 2, this.getData().size() - 1));
    }

    @Override
    public void update() {
        this.setEnabled(!this.isBusy() && this.getTable().getSelectedRowCount() == 1 && this.getTable().getRowCount() > 1);
    }
}

