/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.datatable.action;

import adams.core.ClassLister;
import adams.core.MessageCollection;
import adams.data.indexedsplits.IndexedSplitsRuns;
import adams.data.io.output.AbstractIndexedSplitsRunsWriter;
import adams.data.io.output.JsonIndexedSplitsRunsWriter;
import adams.flow.transformer.indexedsplitsrunsgenerator.InstancesIndexedSplitsRunsGenerator;
import adams.flow.transformer.indexedsplitsrunsgenerator.InstancesRandomSplitGenerator;
import adams.gui.chooser.FileChooserPanel;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.core.ParameterPanel;
import adams.gui.dialog.ApprovalDialog;
import adams.gui.goe.GenericObjectEditorPanel;
import adams.gui.tools.wekainvestigator.data.DataContainer;
import adams.gui.tools.wekainvestigator.data.FileContainer;
import adams.gui.tools.wekainvestigator.datatable.action.AbstractEditableDataTableAction;
import adams.gui.tools.wekainvestigator.job.InvestigatorTabJob;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.filechooser.FileFilter;

public class SaveIndexedSplitsRuns
extends AbstractEditableDataTableAction {
    private static final long serialVersionUID = -8374323161691034031L;
    protected ApprovalDialog m_Dialog;
    protected GenericObjectEditorPanel m_PanelGenerator;
    protected GenericObjectEditorPanel m_PanelWriter;
    protected FileChooserPanel m_PanelOutput;

    public SaveIndexedSplitsRuns() {
        this.setName("Save indexed splits runs");
        this.setIcon("indexed_splits_runs.gif");
        this.setAsynchronous(true);
    }

    protected void doActionPerformed(ActionEvent e) {
        if (this.m_Dialog == null) {
            this.m_Dialog = this.getOwner().getParentDialog() != null ? new ApprovalDialog(this.getOwner().getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new ApprovalDialog(this.getOwner().getParentFrame(), true);
            this.m_Dialog.setTitle("Save indexed splits runs");
            ParameterPanel panelParams = new ParameterPanel();
            this.m_Dialog.getContentPane().add((Component)panelParams, "Center");
            this.m_PanelGenerator = new GenericObjectEditorPanel(InstancesIndexedSplitsRunsGenerator.class, (Object)new InstancesRandomSplitGenerator(), true);
            panelParams.addParameter("Generator", (Component)this.m_PanelGenerator);
            this.m_PanelWriter = new GenericObjectEditorPanel(AbstractIndexedSplitsRunsWriter.class, (Object)new JsonIndexedSplitsRunsWriter(), true);
            panelParams.addParameter("Writer", (Component)this.m_PanelWriter);
            this.m_PanelOutput = new FileChooserPanel();
            this.m_PanelOutput.setAcceptAllFileFilterUsed(false);
            this.m_PanelOutput.setPromptOverwriteFile(true);
            this.m_PanelOutput.setAutoAppendExtension(true);
            for (Class cls : ClassLister.getSingleton().getClasses(AbstractIndexedSplitsRunsWriter.class)) {
                try {
                    AbstractIndexedSplitsRunsWriter writer = (AbstractIndexedSplitsRunsWriter)cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    ExtensionFileFilter fileFilter = new ExtensionFileFilter(writer.getFormatDescription(), writer.getFormatExtensions());
                    this.m_PanelOutput.addChoosableFileFilter((FileFilter)fileFilter);
                    if (!(writer instanceof JsonIndexedSplitsRunsWriter)) continue;
                    this.m_PanelOutput.setFileFilter((FileFilter)fileFilter);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            panelParams.addParameter("Output", (Component)this.m_PanelOutput);
            this.m_Dialog.pack();
            this.m_Dialog.setLocationRelativeTo(null);
        }
        this.m_Dialog.setVisible(true);
        if (this.m_Dialog.getOption() != 0) {
            return;
        }
        DataContainer[] conts = this.getSelectedData();
        final DataContainer data = conts[0];
        this.getOwner().startExecution(new InvestigatorTabJob(this.getOwner(), this.m_Dialog.getTitle()){

            @Override
            protected void doRun() {
                InstancesIndexedSplitsRunsGenerator generator = (InstancesIndexedSplitsRunsGenerator)SaveIndexedSplitsRuns.this.m_PanelGenerator.getCurrent();
                AbstractIndexedSplitsRunsWriter writer = (AbstractIndexedSplitsRunsWriter)SaveIndexedSplitsRuns.this.m_PanelWriter.getCurrent();
                File outputFile = (File)SaveIndexedSplitsRuns.this.m_PanelOutput.getCurrent();
                MessageCollection errors = new MessageCollection();
                try {
                    IndexedSplitsRuns runs = generator.generate(data.getData(), errors);
                    if (runs == null) {
                        if (errors.isEmpty()) {
                            SaveIndexedSplitsRuns.this.logError("Failed to generate indexed splits runs!", this.getTitle());
                        } else {
                            SaveIndexedSplitsRuns.this.logError("Failed to generate indexed splits runs:\n" + errors, this.getTitle());
                        }
                        return;
                    }
                    if (data instanceof FileContainer) {
                        runs.getMetaData().put((Object)"file", (Object)data.getSource());
                    }
                    if (!writer.write(outputFile.getAbsoluteFile(), runs, errors)) {
                        if (errors.isEmpty()) {
                            SaveIndexedSplitsRuns.this.logError("Failed to write indexed splits runs to '" + outputFile + "'!", this.getTitle());
                        } else {
                            SaveIndexedSplitsRuns.this.logError("Failed to write indexed splits runs to '" + outputFile + "':\n" + errors, this.getTitle());
                        }
                    } else {
                        SaveIndexedSplitsRuns.this.showStatus("Indexed splits runs written to: " + outputFile);
                    }
                }
                catch (Exception ex) {
                    SaveIndexedSplitsRuns.this.logError("Failed to save indexed splits runs: " + outputFile + "\n", ex, this.getTitle());
                }
            }
        });
    }

    @Override
    public void update() {
        this.setEnabled(!this.isBusy() && this.getTable().getSelectedRowCount() == 1);
    }
}

