/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.output;

import adams.core.CleanUpHandler;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.ButtonTabComponent;
import adams.gui.core.DragAndDropTabbedPane;
import adams.gui.core.GUIHelper;
import adams.gui.core.ImageManager;
import adams.gui.goe.GenericObjectEditorDialog;
import adams.gui.visualization.multiobjectexport.AbstractMultiObjectExport;
import adams.gui.visualization.multiobjectexport.DirectoryExport;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import javax.swing.Icon;
import javax.swing.JComponent;

public class OutputTabbedPane
extends DragAndDropTabbedPane
implements CleanUpHandler {
    private static final long serialVersionUID = -7694010290845155428L;
    protected AbstractMultiObjectExport m_LastExport;

    protected void initialize() {
        super.initialize();
        this.setShowCloseTabButton(true);
    }

    public int newTab(String title, JComponent comp) {
        this.addTab(title, comp);
        ButtonTabComponent button = (ButtonTabComponent)this.getTabComponentAt(this.getTabCount() - 1);
        button.setIcon((Icon)ImageManager.getIcon((String)"menu.gif"));
        return this.getTabCount() - 1;
    }

    protected Component getActualComponentAt(int index) {
        Component result = this.getComponentAt(index);
        if (result instanceof BaseScrollPane) {
            result = ((BaseScrollPane)result).getViewport().getView();
        }
        return result;
    }

    public void removeTabAt(int index) {
        Component comp = this.getActualComponentAt(index);
        super.removeTabAt(index);
        if (comp instanceof CleanUpHandler) {
            ((CleanUpHandler)comp).cleanUp();
        }
    }

    public void export() {
        if (this.m_LastExport == null) {
            this.m_LastExport = new DirectoryExport();
        }
        GenericObjectEditorDialog dialog = GUIHelper.getParentDialog((Container)((Object)this)) != null ? new GenericObjectEditorDialog(GUIHelper.getParentDialog((Container)((Object)this)), Dialog.ModalityType.DOCUMENT_MODAL) : new GenericObjectEditorDialog(GUIHelper.getParentFrame((Container)((Object)this)), true);
        dialog.setDefaultCloseOperation(2);
        dialog.setTitle("Export output");
        dialog.setUISettingsPrefix(AbstractMultiObjectExport.class);
        dialog.getGOEEditor().setCanChangeClassInDialog(true);
        dialog.getGOEEditor().setClassType(AbstractMultiObjectExport.class);
        dialog.setCurrent((Object)this.m_LastExport);
        dialog.pack();
        dialog.setLocationRelativeTo((Component)dialog.getParent());
        dialog.setVisible(true);
        if (dialog.getResult() != 0) {
            return;
        }
        this.m_LastExport = (AbstractMultiObjectExport)dialog.getCurrent();
        String[] names = new String[this.getTabCount()];
        Object[] objects = new Object[this.getTabCount()];
        for (int i = 0; i < this.getTabCount(); ++i) {
            names[i] = this.getTitleAt(i);
            objects[i] = this.getActualComponentAt(i);
        }
        String msg = this.m_LastExport.export(names, objects);
        if (msg != null) {
            GUIHelper.showErrorMessage((Component)dialog.getParent(), (String)("Failed to export outputs!\n" + msg));
        }
    }

    public void cleanUp() {
        this.removeAll();
    }
}

