/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.output;

import adams.data.io.output.CsvSpreadSheetWriter;
import adams.data.io.output.SpreadSheetWriter;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetSupporter;
import adams.gui.chooser.SpreadSheetFileChooser;
import adams.gui.core.BaseTable;
import adams.gui.core.BaseTableWithButtons;
import adams.gui.core.JTableHelper;
import adams.gui.core.SearchPanel;
import adams.gui.core.SortableAndSearchableTable;
import adams.gui.core.SortableAndSearchableTableWithButtons;
import adams.gui.tools.wekainvestigator.output.AbstractOutputPanelWithPopupMenu;
import com.github.fracpete.jclipboardhelper.ClipboardHelper;
import com.googlecode.jfilechooserbookmarks.gui.BaseScrollPane;
import java.awt.Component;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import javax.swing.JComponent;
import javax.swing.JTable;

public class TableContentPanel
extends AbstractOutputPanelWithPopupMenu<SpreadSheetFileChooser>
implements SpreadSheetSupporter {
    private static final long serialVersionUID = 8183731075946484533L;
    protected JComponent m_Component;
    protected SearchPanel m_PanelSearch;

    public TableContentPanel(JTable comp, boolean useScrollPane) {
        this.initGUI(comp, useScrollPane);
    }

    public TableContentPanel(BaseTable comp, boolean useScrollPane) {
        this.initGUI((JComponent)comp, useScrollPane);
    }

    public TableContentPanel(BaseTableWithButtons comp, boolean useScrollPane) {
        this.initGUI((JComponent)comp, useScrollPane);
    }

    public TableContentPanel(SortableAndSearchableTable comp, boolean useScrollPane, boolean searchable) {
        this.initGUI((JComponent)comp, useScrollPane, searchable);
    }

    public TableContentPanel(SortableAndSearchableTableWithButtons comp, boolean useScrollPane, boolean searchable) {
        this.initGUI((JComponent)comp, useScrollPane, searchable);
    }

    protected void initGUI(JComponent comp, boolean useScrollPane) {
        this.initGUI(comp, useScrollPane, false);
    }

    protected void initGUI(JComponent comp, boolean useScrollPane, boolean searchable) {
        this.m_Component = comp;
        if (useScrollPane) {
            this.getContentPanel().add((Component)new BaseScrollPane((Component)this.m_Component), (Object)"Center");
        } else {
            this.getContentPanel().add((Component)this.m_Component, (Object)"Center");
        }
        this.m_PanelSearch = null;
        if (searchable) {
            this.m_PanelSearch = new SearchPanel(SearchPanel.LayoutType.HORIZONTAL, true);
            this.m_PanelSearch.addSearchListener(e -> {
                if (this.m_Component instanceof SortableAndSearchableTable) {
                    ((SortableAndSearchableTable)this.m_Component).search(e.getParameters().getSearchString(), e.getParameters().isRegExp());
                } else if (this.m_Component instanceof SortableAndSearchableTableWithButtons) {
                    ((SortableAndSearchableTableWithButtons)this.m_Component).search(e.getParameters().getSearchString(), e.getParameters().isRegExp());
                }
            });
            this.getContentPanel().add((Component)this.m_PanelSearch, (Object)"South");
        }
    }

    public JComponent getComponent() {
        return this.m_Component;
    }

    @Override
    protected SpreadSheetFileChooser createFileChooser() {
        SpreadSheetFileChooser result = new SpreadSheetFileChooser();
        result.setAcceptAllFileFilterUsed(false);
        result.setAutoAppendExtension(true);
        return result;
    }

    @Override
    protected String save(File file) {
        SpreadSheetWriter writer;
        String result = null;
        SpreadSheet content = this.toSpreadSheet();
        if (content == null) {
            result = "Unhandled component: " + this.m_Component.getClass().getName();
        }
        if (result == null && !(writer = (SpreadSheetWriter)((SpreadSheetFileChooser)this.getFileChooser()).getWriter()).write(content, file)) {
            result = "Failed to write data to: " + file;
        }
        return result;
    }

    public SpreadSheet toSpreadSheet() {
        Object result = this.m_Component instanceof BaseTable ? ((BaseTable)this.m_Component).toSpreadSheet() : (this.m_Component instanceof BaseTableWithButtons ? ((BaseTableWithButtons)this.m_Component).toSpreadSheet() : (this.m_Component instanceof JTable ? JTableHelper.toSpreadSheet((JTable)((JTable)this.m_Component)) : null));
        return result;
    }

    @Override
    public boolean canCopyToClipboard() {
        return true;
    }

    @Override
    public void copyToClipboard() {
        StringWriter swriter = new StringWriter();
        SpreadSheet sheet = this.toSpreadSheet();
        CsvSpreadSheetWriter writer = new CsvSpreadSheetWriter();
        writer.setSeparator("\\t");
        writer.write(sheet, (Writer)swriter);
        ClipboardHelper.copyToClipboard((String)swriter.toString());
    }
}

